/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.impls.tg;

import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.impls.tg.TinkerEdge;
import com.tinkerpop.blueprints.impls.tg.TinkerGraph;
import com.tinkerpop.blueprints.impls.tg.TinkerIndex;
import com.tinkerpop.blueprints.impls.tg.TinkerVertex;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;

class TinkerMetadataReader {
    private final TinkerGraph graph;

    public TinkerMetadataReader(TinkerGraph graph) {
        this.graph = graph;
    }

    public void load(String filename) throws IOException {
        FileInputStream fos = new FileInputStream(filename);
        this.load(fos);
        fos.close();
    }

    public void load(InputStream inputStream) throws IOException {
        DataInputStream reader = null;
        try {
            reader = new DataInputStream(inputStream);
            this.graph.currentId = reader.readLong();
            this.readIndices(reader, this.graph);
            this.readVertexKeyIndices(reader, this.graph);
            this.readEdgeKeyIndices(reader, this.graph);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not read metadata file");
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Could not read metadata file");
            }
        }
    }

    public static void load(TinkerGraph graph, InputStream inputStream) throws IOException {
        TinkerMetadataReader reader = new TinkerMetadataReader(graph);
        reader.load(inputStream);
    }

    public static void load(TinkerGraph graph, String filename) throws IOException {
        TinkerMetadataReader reader = new TinkerMetadataReader(graph);
        reader.load(filename);
    }

    private void readIndices(DataInputStream reader, TinkerGraph graph) throws IOException {
        int indexCount = reader.readInt();
        for (int i = 0; i < indexCount; ++i) {
            String indexName = reader.readUTF();
            byte indexType = reader.readByte();
            if (indexType != 1 && indexType != 2) {
                throw new RuntimeException("Unknown index class type");
            }
            TinkerIndex<Vertex> tinkerIndex = new TinkerIndex<Vertex>(indexName, indexType == 1 ? Vertex.class : Edge.class);
            int indexItemCount = reader.readInt();
            for (int j = 0; j < indexItemCount; ++j) {
                String indexItemKey = reader.readUTF();
                int indexValueItemSetCount = reader.readInt();
                for (int k = 0; k < indexValueItemSetCount; ++k) {
                    int setCount = reader.readInt();
                    for (int l = 0; l < setCount; ++l) {
                        Edge e;
                        if (indexType == 1) {
                            Vertex v = graph.getVertex(this.readTypedData(reader));
                            if (v == null) continue;
                            tinkerIndex.put(indexItemKey, v.getProperty(indexItemKey), v);
                            continue;
                        }
                        if (indexType != 2 || (e = graph.getEdge(this.readTypedData(reader))) == null) continue;
                        tinkerIndex.put(indexItemKey, e.getProperty(indexItemKey), (Vertex)((Object)e));
                    }
                }
            }
            graph.indices.put(indexName, tinkerIndex);
        }
    }

    private void readVertexKeyIndices(DataInputStream reader, TinkerGraph graph) throws IOException {
        int indexCount = reader.readInt();
        for (int i = 0; i < indexCount; ++i) {
            String indexName = reader.readUTF();
            graph.vertexKeyIndex.createKeyIndex(indexName);
            HashMap items = new HashMap();
            int itemCount = reader.readInt();
            for (int j = 0; j < itemCount; ++j) {
                Object key = this.readTypedData(reader);
                HashSet<TinkerVertex> vertices = new HashSet<TinkerVertex>();
                int vertexCount = reader.readInt();
                for (int k = 0; k < vertexCount; ++k) {
                    Vertex v = graph.getVertex(this.readTypedData(reader));
                    if (v == null) continue;
                    vertices.add((TinkerVertex)v);
                }
                items.put(key, vertices);
            }
            graph.vertexKeyIndex.index.put(indexName, items);
        }
    }

    private void readEdgeKeyIndices(DataInputStream reader, TinkerGraph graph) throws IOException {
        int indexCount = reader.readInt();
        for (int i = 0; i < indexCount; ++i) {
            String indexName = reader.readUTF();
            graph.edgeKeyIndex.createKeyIndex(indexName);
            HashMap items = new HashMap();
            int itemCount = reader.readInt();
            for (int j = 0; j < itemCount; ++j) {
                Object key = this.readTypedData(reader);
                HashSet<TinkerEdge> edges = new HashSet<TinkerEdge>();
                int edgeCount = reader.readInt();
                for (int k = 0; k < edgeCount; ++k) {
                    Edge e = graph.getEdge(this.readTypedData(reader));
                    if (e == null) continue;
                    edges.add((TinkerEdge)e);
                }
                items.put(key, edges);
            }
            graph.edgeKeyIndex.index.put(indexName, items);
        }
    }

    private Object readTypedData(DataInputStream reader) throws IOException {
        byte type = reader.readByte();
        if (type == 1) {
            return reader.readUTF();
        }
        if (type == 2) {
            return reader.readInt();
        }
        if (type == 3) {
            return reader.readLong();
        }
        if (type == 4) {
            return reader.readShort();
        }
        if (type == 5) {
            return Float.valueOf(reader.readFloat());
        }
        if (type == 6) {
            return reader.readDouble();
        }
        throw new IOException("unknown data type: use java serialization");
    }
}

