/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket;

import java.util.Collection;
import java.util.Comparator;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.common.util.Comparators;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.HasAggregations;
import org.elasticsearch.search.aggregations.support.OrderPath;

public interface MultiBucketsAggregation
extends Aggregation {
    public Collection<? extends Bucket> getBuckets();

    public <B extends Bucket> B getBucketByKey(String var1);

    public static interface Bucket
    extends HasAggregations {
        public String getKey();

        public Text getKeyAsText();

        public long getDocCount();

        @Override
        public Aggregations getAggregations();

        public static class SubAggregationComparator<B extends Bucket>
        implements Comparator<B> {
            private final OrderPath path;
            private final boolean asc;

            public SubAggregationComparator(String expression, boolean asc) {
                this.asc = asc;
                this.path = OrderPath.parse(expression);
            }

            public boolean asc() {
                return this.asc;
            }

            public OrderPath path() {
                return this.path;
            }

            @Override
            public int compare(B b1, B b2) {
                double v1 = this.path.resolveValue((HasAggregations)b1);
                double v2 = this.path.resolveValue((HasAggregations)b2);
                return Comparators.compareDiscardNaN(v1, v2, this.asc);
            }
        }
    }
}

