/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.sesametools;

public class Formatting {
    private static final int FOUR = 4;
    private static final int EIGHT = 8;
    private static final int SIXTEEN = 16;

    public static String escapeString(String s) {
        StringBuilder sb = new StringBuilder();
        block7: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\\': {
                    sb.append("\\\\");
                    continue block7;
                }
                case '\"': {
                    sb.append("\\\"");
                    continue block7;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block7;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block7;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block7;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static String unescapeString(String s) {
        StringBuilder sb = new StringBuilder();
        block10: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if ('\\' == c) {
                switch (s.charAt(++i)) {
                    case '\\': {
                        sb.append('\\');
                        continue block10;
                    }
                    case '\'': {
                        sb.append('\'');
                        continue block10;
                    }
                    case '\"': {
                        sb.append('\"');
                        continue block10;
                    }
                    case 't': {
                        sb.append('\t');
                        continue block10;
                    }
                    case 'n': {
                        sb.append('\n');
                        continue block10;
                    }
                    case 'r': {
                        sb.append('\r');
                        continue block10;
                    }
                    case 'u': {
                        String seq = s.substring(i + 1, i + 4 + 1);
                        sb.append(Formatting.toUnicodeChar(seq));
                        i += 4;
                        continue block10;
                    }
                    case 'U': {
                        String seq = s.substring(i + 1, i + 8 + 1);
                        sb.append(Formatting.toUnicodeChar(seq));
                        i += 8;
                        continue block10;
                    }
                    default: {
                        throw new IllegalArgumentException("bad escape sequence: \\" + s.charAt(i) + " at character " + (i - 1));
                    }
                }
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static char toUnicodeChar(String unicode) {
        return (char)Integer.parseInt(unicode, 16);
    }
}

