/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.sql;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.vertexium.VertexiumException;
import org.vertexium.sql.SqlGraphConfiguration;
import org.vertexium.util.VertexiumLogger;
import org.vertexium.util.VertexiumLoggerFactory;

public class SqlGraphDDL {
    private static final VertexiumLogger LOGGER = VertexiumLoggerFactory.getLogger(SqlGraphDDL.class);
    private static final String BIG_CHAR_COLUMN_TYPE = "clob";
    private static final String BIG_BIN_COLUMN_TYPE = "blob";
    private static final String GET_TABLES_TABLE_NAME_COLUMN = "TABLE_NAME";
    private static final int VARCHAR_SIZE = 4000;

    public static void create(DataSource dataSource, SqlGraphConfiguration graphConfig) {
        SqlGraphDDL.createMapTable(dataSource, graphConfig.tableNameWithPrefix("vertex"), BIG_CHAR_COLUMN_TYPE);
        SqlGraphDDL.createMapTable(dataSource, graphConfig.tableNameWithPrefix("edge"), BIG_CHAR_COLUMN_TYPE, "in_vertex_id varchar(4000), out_vertex_id varchar(4000)");
        SqlGraphDDL.createMapTable(dataSource, graphConfig.tableNameWithPrefix("metadata"), BIG_CHAR_COLUMN_TYPE);
        SqlGraphDDL.createStreamingPropertiesTable(dataSource, graphConfig.tableNameWithPrefix("streaming_properties"));
    }

    private static void createMapTable(DataSource dataSource, String tableName, String valueColumnType) {
        SqlGraphDDL.createMapTable(dataSource, tableName, valueColumnType, "");
    }

    private static void createMapTable(DataSource dataSource, String tableName, String valueColumnType, String additionalColumns) {
        if (!additionalColumns.isEmpty()) {
            additionalColumns = ", " + additionalColumns;
        }
        String sql = String.format("CREATE TABLE IF NOT EXISTS %s (%s varchar(4000) primary key, %s %s not null %s)", tableName, "id", "object", valueColumnType, additionalColumns);
        SqlGraphDDL.runSql(dataSource, sql, tableName);
    }

    private static void createStreamingPropertiesTable(DataSource dataSource, String tableName) {
        String sql = String.format("CREATE TABLE IF NOT EXISTS %s (%s varchar(4000) primary key, %s %s not null, %s varchar(4000) not null, %s bigint not null)", tableName, "id", "data", BIG_BIN_COLUMN_TYPE, "type", "length");
        SqlGraphDDL.runSql(dataSource, sql, tableName);
    }

    private static void runSql(DataSource dataSource, String sql, String tableName) {
        block26: {
            try (Connection connection = dataSource.getConnection();){
                if (SqlGraphDDL.doesTableExist(connection, tableName)) break block26;
                LOGGER.info("creating table %s (sql: %s)", new Object[]{tableName, sql});
                try (Statement statement = connection.createStatement();){
                    statement.execute(sql);
                }
            }
            catch (SQLException ex) {
                throw new VertexiumException("Could not create SQL table: " + tableName + " (sql: " + sql + ")", (Throwable)ex);
            }
        }
    }

    private static boolean doesTableExist(Connection connection, String tableName) throws SQLException {
        ResultSet tables = connection.getMetaData().getTables(null, null, "%", null);
        while (tables.next()) {
            if (!tableName.equalsIgnoreCase(tables.getString(GET_TABLES_TABLE_NAME_COLUMN))) continue;
            return true;
        }
        return false;
    }
}

