/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.storage;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.cache2k.StorageConfiguration;
import org.cache2k.storage.ByReferenceHeapStorage;
import org.cache2k.storage.CacheStorage;
import org.cache2k.storage.CacheStorageContext;
import org.cache2k.storage.CacheStorageProviderWithVoidConfig;
import org.cache2k.storage.StorageEntry;

public class ByReferenceHeapStorageImpl
implements CacheStorage {
    StorageConfiguration<Void> config;
    CacheStorageContext context;
    HashMap<Object, HeapEntry> entries;

    public void open(CacheStorageContext ctx, StorageConfiguration<Void> cfg) {
        this.context = ctx;
        this.config = cfg;
        final int entryCapacity = cfg.getEntryCapacity();
        this.entries = entryCapacity == Integer.MAX_VALUE ? new HashMap() : new LinkedHashMap<Object, HeapEntry>(100, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<Object, HeapEntry> _eldest) {
                if (ByReferenceHeapStorageImpl.this.getEntryCount() > entryCapacity) {
                    ByReferenceHeapStorageImpl.this.context.notifyExpired(_eldest.getValue());
                    return true;
                }
                return false;
            }
        };
    }

    @Override
    public synchronized StorageEntry get(Object key) throws Exception {
        return this.entries.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(StorageEntry e) throws Exception {
        HeapEntry he = new HeapEntry();
        he.key = e.getKey();
        he.value = e.getValueOrException();
        he.updated = e.getCreatedOrUpdated();
        he.entryExpiry = e.getEntryExpiryTime();
        he.valueExpiry = e.getValueExpiryTime();
        ByReferenceHeapStorageImpl byReferenceHeapStorageImpl = this;
        synchronized (byReferenceHeapStorageImpl) {
            this.entries.put(e.getKey(), he);
        }
    }

    @Override
    public synchronized boolean remove(Object key) throws Exception {
        return this.entries.remove(key) != null;
    }

    @Override
    public synchronized boolean contains(Object key) throws Exception {
        return this.entries.containsKey(key);
    }

    @Override
    public synchronized void clear() throws Exception {
        this.entries.clear();
    }

    @Override
    public void close() throws Exception {
        this.entries = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visit(CacheStorage.VisitContext ctx, CacheStorage.EntryFilter f, CacheStorage.EntryVisitor v) throws Exception {
        ArrayList<StorageEntry> l = new ArrayList<StorageEntry>();
        ByReferenceHeapStorageImpl byReferenceHeapStorageImpl = this;
        synchronized (byReferenceHeapStorageImpl) {
            for (StorageEntry storageEntry : this.entries.values()) {
                if (!f.shouldInclude(storageEntry.getKey())) continue;
                l.add(storageEntry);
            }
        }
        for (StorageEntry e : l) {
            if (!f.shouldInclude(e.getKey())) continue;
            v.visit(e);
        }
    }

    @Override
    public synchronized int getEntryCount() {
        return this.entries.size();
    }

    public static class Provider
    extends CacheStorageProviderWithVoidConfig
    implements ByReferenceHeapStorage {
        public ByReferenceHeapStorageImpl create(CacheStorageContext ctx, StorageConfiguration<Void> cfg) {
            ByReferenceHeapStorageImpl st = new ByReferenceHeapStorageImpl();
            st.open(ctx, cfg);
            return st;
        }
    }

    static class HeapEntry
    implements StorageEntry {
        Object key;
        Object value;
        long updated;
        long valueExpiry;
        long entryExpiry;

        HeapEntry() {
        }

        @Override
        public Object getKey() {
            return this.key;
        }

        @Override
        public Object getValueOrException() {
            return this.value;
        }

        @Override
        public long getCreatedOrUpdated() {
            return this.updated;
        }

        @Override
        public long getValueExpiryTime() {
            return this.valueExpiry;
        }

        @Override
        public long getEntryExpiryTime() {
            return this.entryExpiry;
        }
    }
}

