/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.accumulo.iterator.model;

import org.apache.hadoop.io.Text;
import org.vertexium.accumulo.iterator.model.KeyBase;

public class PropertyColumnQualifier
extends KeyBase {
    public static final int PART_INDEX_PROPERTY_NAME = 0;
    public static final int PART_INDEX_PROPERTY_KEY = 1;
    private final String[] parts;

    public PropertyColumnQualifier(Text columnQualifier) {
        this.parts = PropertyColumnQualifier.splitOnValueSeparator(columnQualifier.toString(), 2);
    }

    public PropertyColumnQualifier(String propertyName, String propertyKey) {
        this.parts = new String[]{propertyName, propertyKey};
    }

    public String getPropertyName() {
        return this.parts[0];
    }

    public String getPropertyKey() {
        return this.parts[1];
    }

    public String getDiscriminator(String visibilityString, long timestamp) {
        PropertyColumnQualifier.assertNoValueSeparator(this.getPropertyName());
        PropertyColumnQualifier.assertNoValueSeparator(this.getPropertyKey());
        PropertyColumnQualifier.assertNoValueSeparator(visibilityString);
        String timestampString = Long.toString(timestamp);
        int length = this.getPropertyName().length() + 1 + this.getPropertyKey().length() + 1 + visibilityString.length() + 1 + timestampString.length();
        return new StringBuilder(length).append(this.getPropertyName()).append('\u001f').append(this.getPropertyKey()).append('\u001f').append(visibilityString).append('\u001f').append(timestampString).toString();
    }
}

