/*
 * Decompiled with CFR 0.152.
 */
package info.aduna.iteration;

import info.aduna.iteration.InterruptTask;
import info.aduna.iteration.Iteration;
import info.aduna.iteration.IterationWrapper;
import java.util.NoSuchElementException;
import java.util.Timer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TimeLimitIteration<E, X extends Exception>
extends IterationWrapper<E, X> {
    private static Timer timer = null;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final InterruptTask<E, X> interruptTask;
    private volatile boolean isInterrupted = false;

    private static synchronized Timer getTimer() {
        if (timer == null) {
            timer = new Timer("TimeLimitIteration", true);
        }
        return timer;
    }

    public TimeLimitIteration(Iteration<? extends E, ? extends X> iter, long timeLimit) {
        super(iter);
        assert (timeLimit > 0L) : "time limit must be a positive number, is: " + timeLimit;
        this.interruptTask = new InterruptTask(this);
        TimeLimitIteration.getTimer().schedule(this.interruptTask, timeLimit);
    }

    @Override
    public boolean hasNext() throws X {
        this.checkInterrupted();
        try {
            boolean result = super.hasNext();
            this.checkInterrupted();
            return result;
        }
        catch (NoSuchElementException e) {
            this.checkInterrupted();
            throw e;
        }
    }

    @Override
    public E next() throws X {
        this.checkInterrupted();
        try {
            return super.next();
        }
        catch (NoSuchElementException e) {
            this.checkInterrupted();
            throw e;
        }
    }

    @Override
    public void remove() throws X {
        this.checkInterrupted();
        super.remove();
    }

    @Override
    protected void handleClose() throws X {
        this.interruptTask.cancel();
        super.handleClose();
    }

    private final void checkInterrupted() throws X {
        if (this.isInterrupted) {
            this.throwInterruptedException();
        }
    }

    protected abstract void throwInterruptedException() throws X;

    void interrupt() {
        this.isInterrupted = true;
        if (!this.isClosed()) {
            try {
                this.close();
            }
            catch (Exception e) {
                this.logger.warn("Failed to close iteration", (Throwable)e);
            }
        }
    }
}

