/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.impl;

import java.io.NotSerializableException;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.cache2k.Cache;
import org.cache2k.CacheConfig;
import org.cache2k.ClosableIterator;
import org.cache2k.StorageConfiguration;
import org.cache2k.impl.BaseCache;
import org.cache2k.impl.CacheClosedException;
import org.cache2k.impl.CacheInternalError;
import org.cache2k.impl.CacheStorageException;
import org.cache2k.impl.ClearStorageBuffer;
import org.cache2k.impl.ClosableConcurrentHashEntryIterator;
import org.cache2k.impl.Entry;
import org.cache2k.impl.Hash;
import org.cache2k.impl.NoopStorageAdapter;
import org.cache2k.impl.StorageAdapter;
import org.cache2k.impl.threading.Futures;
import org.cache2k.impl.threading.LimitedPooledExecutor;
import org.cache2k.impl.timer.TimerListener;
import org.cache2k.impl.timer.TimerService;
import org.cache2k.impl.util.Log;
import org.cache2k.impl.util.TunableConstants;
import org.cache2k.impl.util.TunableFactory;
import org.cache2k.spi.SingleProviderResolver;
import org.cache2k.storage.CacheStorage;
import org.cache2k.storage.CacheStorageContext;
import org.cache2k.storage.CacheStorageProvider;
import org.cache2k.storage.FlushableStorage;
import org.cache2k.storage.MarshallerFactory;
import org.cache2k.storage.Marshallers;
import org.cache2k.storage.PurgeableStorage;
import org.cache2k.storage.StorageEntry;
import org.cache2k.storage.TransientStorageClass;

public class PassingStorageAdapter
extends StorageAdapter {
    private Tunable tunable = TunableFactory.get(Tunable.class);
    private BaseCache cache;
    CacheStorage storage;
    boolean passivation = false;
    boolean storageIsTransient = false;
    long errorCount = 0L;
    Set<Object> deletedKeys = null;
    StorageContext context;
    StorageConfiguration config;
    ExecutorService executor;
    long flushIntervalMillis = 0L;
    Object flushLock = new Object();
    TimerService.CancelHandle flushTimerHandle;
    Future<Void> lastExecutingFlush = new Futures.FinishedFuture<Void>();
    Object purgeRunningLock = new Object();
    Log log;
    StorageAdapter.Parent parent;
    static final Entry LAST_ENTRY = new Entry();
    static final ThreadFactory THREAD_FACTORY = new MyThreadFactory();

    public PassingStorageAdapter(BaseCache _cache, CacheConfig _cacheConfig, StorageConfiguration _storageConfig) {
        this.cache = _cache;
        this.parent = _cache;
        this.context = new StorageContext(_cache);
        this.context.keyType = _cacheConfig.getKeyType();
        this.context.valueType = _cacheConfig.getValueType();
        this.config = _storageConfig;
        this.executor = this.tunable.useManagerThreadPool ? new LimitedPooledExecutor(this.cache.manager.getThreadPool()) : Executors.newCachedThreadPool();
        this.context.log = this.log = Log.getLog(Cache.class.getName() + ".storage/" + this.cache.getCompleteName());
    }

    protected void logLifecycleOperation(String s) {
        this.log.info(s);
    }

    @Override
    public void open() {
        try {
            CacheStorageProvider pr = (CacheStorageProvider)SingleProviderResolver.getInstance().resolve(this.config.getImplementation());
            this.storage = pr.create(this.context, this.config);
            if (this.storage instanceof TransientStorageClass) {
                this.storageIsTransient = true;
            }
            this.flushIntervalMillis = this.config.getFlushIntervalMillis();
            if (!(this.storage instanceof FlushableStorage)) {
                this.flushIntervalMillis = -1L;
            }
            if (this.config.isPassivation() || this.storageIsTransient) {
                this.deletedKeys = new HashSet<Object>();
                this.passivation = true;
            }
            this.logLifecycleOperation("opened, state: " + this.storage);
        }
        catch (Exception ex) {
            if (this.config.isReliable()) {
                this.disableAndThrow("error initializing, disabled", ex);
            }
            this.disable("error initializing, disabled", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(Entry e, long _nextRefreshTime) {
        if (this.passivation) {
            Set<Object> set = this.deletedKeys;
            synchronized (set) {
                this.deletedKeys.remove(e.getKey());
            }
            return;
        }
        StorageEntryForPut se = new StorageEntryForPut(e.getKey(), e.getValue(), e.getCreatedOrUpdated(), _nextRefreshTime);
        this.doPut(se);
    }

    private void doPut(StorageEntry e) {
        try {
            this.storage.put(e);
            this.checkStartFlushTimer();
        }
        catch (Exception ex) {
            if (this.config.isReliable() || ex instanceof NotSerializableException) {
                this.disableAndThrow("exception in storage.put()", ex);
            }
            this.storageUnreliableError(ex);
            try {
                if (!this.storage.contains(e.getKey())) {
                    return;
                }
                this.storage.remove(e.getKey());
                this.checkStartFlushTimer();
            }
            catch (Exception ex2) {
                ex.addSuppressed(ex2);
                this.disableAndThrow("exception in storage.put(), mitigation failed, entry state unknown", ex);
            }
        }
    }

    void storageUnreliableError(Throwable ex) {
        if (this.errorCount == 0L) {
            this.log.warn("Storage exception, only first exception is logged, see error counter (reliable=false)", ex);
        }
        ++this.errorCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StorageEntry get(Object k) {
        if (this.deletedKeys != null) {
            Set<Object> set = this.deletedKeys;
            synchronized (set) {
                if (this.deletedKeys.contains(k)) {
                    return null;
                }
            }
        }
        try {
            return this.storage.get(k);
        }
        catch (Exception ex) {
            this.storageUnreliableError(ex);
            if (this.config.isReliable()) {
                throw new CacheStorageException("cache get", ex);
            }
            return null;
        }
    }

    @Override
    public void evict(Entry e) {
        if (this.passivation) {
            this.putEventually(e);
        }
    }

    @Override
    public void expire(Entry e) {
    }

    private void putEventually(Entry e) {
        if (!e.isDirty()) {
            try {
                if (this.storage.contains(e.getKey())) {
                    return;
                }
            }
            catch (Exception ex) {
                this.disableAndThrow("storage.contains(), unknown state", ex);
            }
        }
        this.doPut(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object key) {
        try {
            if (this.deletedKeys != null) {
                Set<Object> set = this.deletedKeys;
                synchronized (set) {
                    if (!this.deletedKeys.contains(key) && this.storage.contains(key)) {
                        this.deletedKeys.add(key);
                        return true;
                    }
                    return false;
                }
            }
            boolean f = this.storage.remove(key);
            this.checkStartFlushTimer();
            return f;
        }
        catch (Exception ex) {
            this.disableAndThrow("storage.remove()", ex);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClosableIterator<Entry> iterateAll() {
        CompleteIterator it = new CompleteIterator();
        it.queue = this.tunable.iterationQueueCapacity > 0 ? new ArrayBlockingQueue<StorageEntry>(this.tunable.iterationQueueCapacity) : new SynchronousQueue<StorageEntry>();
        Object object = this.cache.lock;
        synchronized (object) {
            it.heapIteration = this.cache.iterateAllHeapEntries();
            it.heapIteration.setKeepIterated(true);
            it.keepHashCtrlForClearDetection = this.cache.mainHashCtrl;
        }
        it.executorForStorageCall = this.executor;
        long now = System.currentTimeMillis();
        it.runnable = new StorageVisitCallable(now, it);
        return it;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void purge() {
        Object object = this.purgeRunningLock;
        synchronized (object) {
            PurgeableStorage.PurgeResult res;
            long now = System.currentTimeMillis();
            if (this.storage instanceof PurgeableStorage) {
                try {
                    MyPurgeContext ctx = new MyPurgeContext();
                    res = ((PurgeableStorage)((Object)this.storage)).purge(ctx, now, now);
                }
                catch (Exception ex) {
                    this.disable("expire exception", ex);
                    return;
                }
            } else {
                res = this.purgeByVisit(now, now);
            }
            if (this.log.isInfoEnabled()) {
                long t = System.currentTimeMillis();
                this.log.info("purge (force): runtimeMillis=" + (t - now) + ", " + "scanned=" + res.getEntriesScanned() + ", " + "purged=" + res.getEntriesPurged() + ", " + "until=" + now + (res.getBytesFreed() >= 0L ? ", freedBytes=" + res.getBytesFreed() : ""));
            }
        }
    }

    PurgeableStorage.PurgeResult purgeByVisit(final long _valueExpiryTime, final long _entryExpireTime) {
        CacheStorage.EntryFilter f = new CacheStorage.EntryFilter(){

            @Override
            public boolean shouldInclude(Object _key) {
                return true;
            }
        };
        BaseVisitContext ctx = new BaseVisitContext(){

            @Override
            public boolean needMetaData() {
                return true;
            }

            @Override
            public boolean needValue() {
                return false;
            }
        };
        final AtomicInteger _scanCount = new AtomicInteger();
        final AtomicInteger _purgeCount = new AtomicInteger();
        CacheStorage.EntryVisitor v = new CacheStorage.EntryVisitor(){

            @Override
            public void visit(final StorageEntry _storageEntry) throws Exception {
                _scanCount.incrementAndGet();
                if (_storageEntry.getEntryExpiryTime() > 0L && _storageEntry.getEntryExpiryTime() < _entryExpireTime || _storageEntry.getValueExpiryTime() > 0L && _storageEntry.getValueExpiryTime() < _valueExpiryTime) {
                    PurgeableStorage.PurgeAction _action = new PurgeableStorage.PurgeAction(){

                        @Override
                        public StorageEntry checkAndPurge(Object key) {
                            try {
                                StorageEntry e2 = PassingStorageAdapter.this.storage.get(key);
                                if (_storageEntry.getEntryExpiryTime() == e2.getEntryExpiryTime() && _storageEntry.getValueExpiryTime() == e2.getValueExpiryTime()) {
                                    PassingStorageAdapter.this.storage.remove(key);
                                    _purgeCount.incrementAndGet();
                                    return null;
                                }
                                return e2;
                            }
                            catch (Exception ex) {
                                PassingStorageAdapter.this.disable("storage.remove()", ex);
                                return null;
                            }
                        }
                    };
                    PassingStorageAdapter.this.cache.lockAndRunForPurge(_storageEntry.getKey(), _action);
                }
            }
        };
        try {
            this.storage.visit(ctx, f, v);
            ctx.awaitTermination();
        }
        catch (Exception ex) {
            this.disable("visit exception", ex);
        }
        if (_purgeCount.get() > 0) {
            this.checkStartFlushTimer();
        }
        return new PurgeableStorage.PurgeResult(){

            @Override
            public long getBytesFreed() {
                return -1L;
            }

            @Override
            public int getEntriesPurged() {
                return _purgeCount.get();
            }

            @Override
            public int getEntriesScanned() {
                return _scanCount.get();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkStartFlushTimer() {
        if (this.flushIntervalMillis <= 0L) {
            return;
        }
        Object object = this.flushLock;
        synchronized (object) {
            if (this.flushTimerHandle != null) {
                return;
            }
            this.scheduleFlushTimer();
        }
    }

    private void scheduleFlushTimer() {
        TimerListener l = new TimerListener(){

            @Override
            public void fire(long _time) {
                PassingStorageAdapter.this.onFlushTimerEvent();
            }
        };
        long _fireTime = System.currentTimeMillis() + this.config.getFlushIntervalMillis();
        this.flushTimerHandle = this.cache.timerService.add(l, _fireTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onFlushTimerEvent() {
        Object object = this.flushLock;
        synchronized (object) {
            this.flushTimerHandle.cancel();
            this.flushTimerHandle = null;
            if (this.storage instanceof ClearStorageBuffer || !this.lastExecutingFlush.isDone()) {
                this.checkStartFlushTimer();
                return;
            }
            LimitedPooledExecutor.NeverRunInCallingTask<Void> c = new LimitedPooledExecutor.NeverRunInCallingTask<Void>(){

                @Override
                public Void call() throws Exception {
                    PassingStorageAdapter.this.doStorageFlush();
                    return null;
                }
            };
            this.lastExecutingFlush = this.executor.submit(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void flush() {
        Object object = this.flushLock;
        synchronized (object) {
            if (this.flushTimerHandle != null) {
                this.flushTimerHandle.cancel();
                this.flushTimerHandle = null;
            }
        }
        Callable<Void> c = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                PassingStorageAdapter.this.doStorageFlush();
                return null;
            }
        };
        FutureTask<Void> _inThreadFlush = new FutureTask<Void>(c);
        boolean _anotherFlushSubmittedNotByUs = false;
        while (true) {
            if (!this.lastExecutingFlush.isDone()) {
                try {
                    this.lastExecutingFlush.get();
                    if (_anotherFlushSubmittedNotByUs) {
                        return;
                    }
                }
                catch (Exception ex) {
                    this.disableAndThrow("flush execution", ex);
                }
            }
            PassingStorageAdapter passingStorageAdapter = this;
            synchronized (passingStorageAdapter) {
                if (this.lastExecutingFlush.isDone()) {
                    this.lastExecutingFlush = _inThreadFlush;
                    // MONITOREXIT @DISABLED, blocks:[4, 6, 7] lbl24 : MonitorExitStatement: MONITOREXIT : var4_4
                    _inThreadFlush.run();
                    return;
                }
                _anotherFlushSubmittedNotByUs = true;
            }
        }
    }

    private void doStorageFlush() throws Exception {
        MyFlushContext ctx = new MyFlushContext();
        FlushableStorage _storage = (FlushableStorage)this.storage;
        _storage.flush(ctx, System.currentTimeMillis());
        this.log.info("flushed, state: " + this.storage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Future<Void> cancelTimerJobs() {
        Object object = this.flushLock;
        synchronized (object) {
            if (this.flushIntervalMillis >= 0L) {
                this.flushIntervalMillis = -1L;
            }
            if (this.flushTimerHandle != null) {
                this.flushTimerHandle.cancel();
                this.flushTimerHandle = null;
            }
            if (!this.lastExecutingFlush.isDone()) {
                this.lastExecutingFlush.cancel(false);
                return this.lastExecutingFlush;
            }
        }
        return new Futures.FinishedFuture<Void>();
    }

    @Override
    public Future<Void> shutdown() {
        if (this.storage instanceof ClearStorageBuffer) {
            throw new CacheInternalError("Clear is supposed to be in shutdown wait task queue, so shutdown waits for it.");
        }
        Callable<Void> _closeTaskChain = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                if (PassingStorageAdapter.this.config.isFlushOnClose() || PassingStorageAdapter.this.config.isReliable()) {
                    PassingStorageAdapter.this.flush();
                } else {
                    Future<Void> _previousFlush = PassingStorageAdapter.this.lastExecutingFlush;
                    if (_previousFlush != null) {
                        _previousFlush.cancel(true);
                        _previousFlush.get();
                    }
                }
                PassingStorageAdapter.this.logLifecycleOperation("closing, state: " + PassingStorageAdapter.this.storage);
                PassingStorageAdapter.this.storage.close();
                return null;
            }
        };
        if (this.passivation && !this.storageIsTransient) {
            final Callable<Void> _before = _closeTaskChain;
            _closeTaskChain = new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    PassingStorageAdapter.this.passivateHeapEntriesOnShutdown();
                    PassingStorageAdapter.this.executor.submit(_before);
                    return null;
                }
            };
        }
        return this.executor.submit(_closeTaskChain);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void passivateHeapEntriesOnShutdown() {
        try {
            ClosableConcurrentHashEntryIterator<Entry> it;
            Object object = this.cache.lock;
            synchronized (object) {
                it = this.cache.iterateAllHeapEntries();
            }
            while (it.hasNext()) {
                Entry e;
                Entry entry = e = (Entry)it.next();
                synchronized (entry) {
                    this.putEventually(e);
                }
            }
            if (this.deletedKeys != null) {
                for (Object k : this.deletedKeys) {
                    this.storage.remove(k);
                }
            }
        }
        catch (Exception ex) {
            PassingStorageAdapter.rethrow("shutdown passivation", ex);
        }
    }

    @Override
    public boolean checkStorageStillDisconnectedForClear() {
        ClearStorageBuffer _buffer;
        return this.storage instanceof ClearStorageBuffer && !(_buffer = (ClearStorageBuffer)this.storage).isTransferringToStorage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnectStorageForClear() {
        PassingStorageAdapter passingStorageAdapter = this;
        synchronized (passingStorageAdapter) {
            ClearStorageBuffer _buffer = new ClearStorageBuffer();
            _buffer.nextStorage = this.storage;
            this.storage = _buffer;
            if (_buffer.nextStorage instanceof ClearStorageBuffer) {
                ClearStorageBuffer _ongoingClear = (ClearStorageBuffer)_buffer.nextStorage;
                if (_ongoingClear.clearThreadFuture != null) {
                    _ongoingClear.shouldStop = true;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<Void> clearAndReconnect() {
        FutureTask<Void> f;
        PassingStorageAdapter passingStorageAdapter = this;
        synchronized (passingStorageAdapter) {
            final ClearStorageBuffer _buffer = (ClearStorageBuffer)this.storage;
            if (_buffer.clearThreadFuture != null) {
                return _buffer.clearThreadFuture;
            }
            ClearStorageBuffer _previousBuffer = null;
            if (_buffer.getNextStorage() instanceof ClearStorageBuffer) {
                _previousBuffer = (ClearStorageBuffer)_buffer.getNextStorage();
                _buffer.nextStorage = _buffer.getOriginalStorage();
            }
            final ClearStorageBuffer _waitingBufferStack = _previousBuffer;
            LimitedPooledExecutor.NeverRunInCallingTask<Void> c = new LimitedPooledExecutor.NeverRunInCallingTask<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Void call() throws Exception {
                    try {
                        if (_waitingBufferStack != null) {
                            _waitingBufferStack.waitForAll();
                        }
                    }
                    catch (Exception ex) {
                        PassingStorageAdapter.this.disable("exception during waiting for previous clear", ex);
                        throw new CacheStorageException(ex);
                    }
                    Object ex = this;
                    synchronized (ex) {
                        if (_buffer.shouldStop) {
                            return null;
                        }
                    }
                    try {
                        _buffer.getOriginalStorage().clear();
                    }
                    catch (Exception ex2) {
                        PassingStorageAdapter.this.disable("exception during clear", ex2);
                        throw new CacheStorageException(ex2);
                    }
                    ex = ((PassingStorageAdapter)PassingStorageAdapter.this).cache.lock;
                    synchronized (ex) {
                        _buffer.startTransfer();
                    }
                    try {
                        _buffer.transfer();
                    }
                    catch (Exception ex3) {
                        PassingStorageAdapter.this.disable("exception during clear, operations replay", ex3);
                        throw new CacheStorageException(ex3);
                    }
                    10 var1_2 = this;
                    synchronized (var1_2) {
                        if (_buffer.shouldStop) {
                            return null;
                        }
                        PassingStorageAdapter.this.storage = _buffer.getOriginalStorage();
                    }
                    return null;
                }
            };
            f = new FutureTask<Void>(c);
            _buffer.clearThreadFuture = f;
        }
        f.run();
        return f;
    }

    public void disableAndThrow(String _logMessage, Throwable ex) {
        ++this.errorCount;
        this.disable(ex);
        PassingStorageAdapter.rethrow(_logMessage, ex);
    }

    public void disable(String _logMessage, Throwable ex) {
        this.log.warn(_logMessage, ex);
        this.disable(ex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disable(Throwable ex) {
        if (this.storage == null) {
            return;
        }
        Object object = this.cache.lock;
        synchronized (object) {
            PassingStorageAdapter passingStorageAdapter = this;
            synchronized (passingStorageAdapter) {
                if (this.storage == null) {
                    return;
                }
                CacheStorage _storage = this.storage;
                if (_storage instanceof ClearStorageBuffer) {
                    ClearStorageBuffer _buffer = (ClearStorageBuffer)_storage;
                    _buffer.disableOnFailure(ex);
                }
                try {
                    _storage.close();
                }
                catch (Throwable _ignore) {
                    // empty catch block
                }
                this.storage = null;
                this.parent.resetStorage(this, new NoopStorageAdapter(this.cache));
            }
        }
    }

    @Override
    public int getAlert() {
        if (this.errorCount > 0L) {
            return 1;
        }
        if (this.storage instanceof ClearStorageBuffer) {
            return 1;
        }
        return 0;
    }

    @Override
    public int getTotalEntryCount() {
        if (!this.passivation) {
            return this.storage.getEntryCount();
        }
        return this.storage.getEntryCount() + this.cache.getLocalSize();
    }

    public String toString() {
        return "PassingStorageAdapter(implementation=" + this.getImplementation() + ")";
    }

    public CacheStorage getImplementation() {
        return this.storage;
    }

    ExecutorService createOperationExecutor() {
        return new ThreadPoolExecutor(0, Runtime.getRuntime().availableProcessors() * 123 / 100, 21L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), THREAD_FACTORY, new ThreadPoolExecutor.CallerRunsPolicy());
    }

    public static class Tunable
    extends TunableConstants {
        public int iterationQueueCapacity = 3;
        public boolean useManagerThreadPool = false;
        public int terminationInfoSeconds = 5;
        public int terminationTimeoutSeconds = 200;
    }

    static class StorageEntryForPut
    implements StorageEntry {
        Object key;
        Object value;
        long creationTime;
        long expiryTime;

        StorageEntryForPut(Object key, Object value, long creationTime, long expiryTime) {
            this.key = key;
            this.value = value;
            this.creationTime = creationTime;
            this.expiryTime = expiryTime;
        }

        @Override
        public Object getKey() {
            return this.key;
        }

        @Override
        public Object getValueOrException() {
            return this.value;
        }

        @Override
        public long getCreatedOrUpdated() {
            return this.creationTime;
        }

        @Override
        public long getValueExpiryTime() {
            return this.expiryTime;
        }

        @Override
        public long getEntryExpiryTime() {
            return 0L;
        }
    }

    static class MyThreadFactory
    implements ThreadFactory {
        AtomicInteger count = new AtomicInteger();

        MyThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, "cache2k-storage#" + this.count.incrementAndGet());
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }

    static class StorageContext
    implements CacheStorageContext {
        Log log;
        BaseCache cache;
        Class<?> keyType;
        Class<?> valueType;

        StorageContext(BaseCache cache) {
            this.cache = cache;
        }

        @Override
        public Properties getProperties() {
            return null;
        }

        @Override
        public String getManagerName() {
            return this.cache.manager.getName();
        }

        @Override
        public String getCacheName() {
            return this.cache.getName();
        }

        @Override
        public Class<?> getKeyType() {
            return this.keyType;
        }

        @Override
        public Class<?> getValueType() {
            return this.valueType;
        }

        @Override
        public MarshallerFactory getMarshallerFactory() {
            return Marshallers.getInstance();
        }

        @Override
        public Log getLog() {
            return this.log;
        }

        @Override
        public void requestMaintenanceCall(int _intervalMillis) {
        }

        @Override
        public void notifyEvicted(StorageEntry e) {
        }

        @Override
        public void notifyExpired(StorageEntry e) {
        }
    }

    class MyFlushContext
    extends MyMultiThreadContext
    implements FlushableStorage.FlushContext {
        MyFlushContext() {
        }
    }

    static class StorageIterationException
    extends CacheStorageException {
        StorageIterationException(Throwable cause) {
            super(cause);
        }
    }

    class CompleteIterator
    extends MyMultiThreadContext
    implements ClosableIterator<Entry>,
    CacheStorage.VisitContext {
        Hash keepHashCtrlForClearDetection;
        Entry[] keysIterated;
        ClosableConcurrentHashEntryIterator heapIteration;
        StorageEntry entry;
        BlockingQueue<StorageEntry> queue;
        Callable<Void> runnable;
        Future<Void> futureToCheckAbnormalTermination;
        ExecutorService executorForStorageCall;

        CompleteIterator() {
        }

        @Override
        public boolean needMetaData() {
            return true;
        }

        @Override
        public boolean needValue() {
            return true;
        }

        public boolean hasNext() {
            if (this.heapIteration != null) {
                while (this.heapIteration.hasNext()) {
                    Object e;
                    this.entry = e = this.heapIteration.next();
                    if (!((Entry)e).isDataValidState()) continue;
                    return true;
                }
                this.keysIterated = this.heapIteration.iterated;
                this.futureToCheckAbnormalTermination = this.executorForStorageCall.submit(this.runnable);
                this.heapIteration = null;
            }
            if (this.queue != null) {
                block13: {
                    if (this.abortException != null) {
                        this.queue = null;
                        throw new StorageIterationException(this.abortException);
                    }
                    if (((PassingStorageAdapter)PassingStorageAdapter.this).cache.shutdownInitiated) {
                        throw new CacheClosedException();
                    }
                    if (this.keepHashCtrlForClearDetection.isCleared()) {
                        this.close();
                        return false;
                    }
                    try {
                        block12: {
                            do {
                                this.entry = this.queue.poll(1234L, TimeUnit.MILLISECONDS);
                                if (this.entry != null) break block12;
                            } while (!this.futureToCheckAbnormalTermination.isDone());
                            this.futureToCheckAbnormalTermination.get();
                        }
                        if (this.entry != LAST_ENTRY) {
                            return true;
                        }
                    }
                    catch (InterruptedException _ignore) {
                    }
                    catch (ExecutionException ex) {
                        if (this.abortException != null) break block13;
                        this.abortException = ex;
                    }
                }
                this.queue = null;
                if (this.abortException != null) {
                    throw new CacheStorageException(this.abortException);
                }
            }
            return false;
        }

        public Entry next() {
            return PassingStorageAdapter.this.cache.insertEntryFromStorage(this.entry, false);
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public void close() {
            if (this.heapIteration != null) {
                this.heapIteration.close();
                this.heapIteration = null;
            }
            if (this.executorForStorageCall != null) {
                this.executorForStorageCall.shutdownNow();
                this.executorForStorageCall = null;
                this.queue = null;
            }
        }
    }

    class MyMultiThreadContext
    implements CacheStorage.MultiThreadedContext {
        ExecutorService executorForVisitThread;
        boolean abortFlag;
        Throwable abortException;

        MyMultiThreadContext() {
        }

        @Override
        public ExecutorService getExecutorService() {
            if (this.executorForVisitThread == null) {
                if (((PassingStorageAdapter)PassingStorageAdapter.this).tunable.useManagerThreadPool) {
                    LimitedPooledExecutor ex = new LimitedPooledExecutor(((PassingStorageAdapter)PassingStorageAdapter.this).cache.manager.getThreadPool());
                    ex.setExceptionListener(new LimitedPooledExecutor.ExceptionListener(){

                        @Override
                        public void exceptionWasThrown(Throwable ex) {
                            MyMultiThreadContext.this.abortOnException(ex);
                        }
                    });
                    this.executorForVisitThread = ex;
                } else {
                    this.executorForVisitThread = PassingStorageAdapter.this.createOperationExecutor();
                }
            }
            return this.executorForVisitThread;
        }

        @Override
        public void awaitTermination() throws InterruptedException {
            if (this.executorForVisitThread != null && !this.executorForVisitThread.isTerminated()) {
                if (this.shouldStop()) {
                    this.executorForVisitThread.shutdownNow();
                } else {
                    this.executorForVisitThread.shutdown();
                }
                boolean _terminated = false;
                if (((PassingStorageAdapter)PassingStorageAdapter.this).tunable.terminationInfoSeconds > 0) {
                    _terminated = this.executorForVisitThread.awaitTermination(((PassingStorageAdapter)PassingStorageAdapter.this).tunable.terminationInfoSeconds, TimeUnit.SECONDS);
                }
                if (!_terminated) {
                    if (PassingStorageAdapter.this.log.isInfoEnabled() && ((PassingStorageAdapter)PassingStorageAdapter.this).tunable.terminationInfoSeconds > 0) {
                        PassingStorageAdapter.this.log.info("still waiting for thread termination after " + ((PassingStorageAdapter)PassingStorageAdapter.this).tunable.terminationInfoSeconds + " seconds," + " keep waiting for " + ((PassingStorageAdapter)PassingStorageAdapter.this).tunable.terminationTimeoutSeconds + " seconds...");
                    }
                    if (!(_terminated = this.executorForVisitThread.awaitTermination(((PassingStorageAdapter)PassingStorageAdapter.this).tunable.terminationTimeoutSeconds - ((PassingStorageAdapter)PassingStorageAdapter.this).tunable.terminationInfoSeconds, TimeUnit.SECONDS))) {
                        PassingStorageAdapter.this.log.warn("threads not terminated after " + ((PassingStorageAdapter)PassingStorageAdapter.this).tunable.terminationTimeoutSeconds + " seconds");
                    }
                }
            }
            if (this.abortException != null) {
                throw new RuntimeException("execution exception", this.abortException);
            }
        }

        @Override
        public synchronized void abortOnException(Throwable ex) {
            if (this.abortException == null) {
                this.abortException = ex;
            }
            this.abortFlag = true;
        }

        @Override
        public boolean shouldStop() {
            return this.abortFlag;
        }
    }

    class StorageVisitCallable
    implements LimitedPooledExecutor.NeverRunInCallingTask<Void> {
        long now;
        CompleteIterator it;

        StorageVisitCallable(long now, CompleteIterator it) {
            this.now = now;
            this.it = it;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() {
            final BlockingQueue<StorageEntry> _queue = this.it.queue;
            CacheStorage.EntryVisitor v = new CacheStorage.EntryVisitor(){

                @Override
                public void visit(StorageEntry se) throws InterruptedException {
                    if (se.getValueExpiryTime() != 0L && se.getValueExpiryTime() <= StorageVisitCallable.this.now) {
                        return;
                    }
                    _queue.put(se);
                }
            };
            CacheStorage.EntryFilter f = new CacheStorage.EntryFilter(){

                @Override
                public boolean shouldInclude(Object _key) {
                    return !Hash.contains(StorageVisitCallable.this.it.keysIterated, _key, PassingStorageAdapter.this.cache.modifiedHash(_key.hashCode()));
                }
            };
            try {
                PassingStorageAdapter.this.storage.visit(this.it, f, v);
            }
            catch (Exception ex) {
                this.it.abortOnException(ex);
                _queue.clear();
            }
            finally {
                try {
                    this.it.awaitTermination();
                }
                catch (InterruptedException ex) {}
                while (true) {
                    try {
                        _queue.put(LAST_ENTRY);
                    }
                    catch (InterruptedException ex) {
                        continue;
                    }
                    break;
                }
            }
            return null;
        }
    }

    class MyPurgeContext
    extends MyMultiThreadContext
    implements PurgeableStorage.PurgeContext {
        MyPurgeContext() {
        }

        @Override
        public void lockAndRun(Object key, PurgeableStorage.PurgeAction _action) {
            PassingStorageAdapter.this.cache.lockAndRunForPurge(key, _action);
        }
    }

    abstract class BaseVisitContext
    extends MyMultiThreadContext
    implements CacheStorage.VisitContext {
        BaseVisitContext() {
        }
    }
}

