/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client.coprocessor;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.apache.commons.lang.reflect.MethodUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.ipc.CoprocessorProtocol;

public abstract class Batch {
    private static Log LOG = LogFactory.getLog(Batch.class);

    public static <T extends CoprocessorProtocol, R> Call<T, R> forMethod(Class<T> protocol, String method, Object ... args) throws NoSuchMethodException {
        Class[] types = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            if (args[i] == null) {
                throw new NullPointerException("Method argument cannot be null");
            }
            types[i] = args[i].getClass();
        }
        Method m = MethodUtils.getMatchingAccessibleMethod(protocol, (String)method, (Class[])types);
        if (m == null) {
            throw new NoSuchMethodException("No matching method found for '" + method + "'");
        }
        m.setAccessible(true);
        return Batch.forMethod(m, args);
    }

    public static <T extends CoprocessorProtocol, R> Call<T, R> forMethod(final Method method, final Object ... args) {
        return new Call<T, R>(){

            @Override
            public R call(T instance) throws IOException {
                try {
                    if (Proxy.isProxyClass(instance.getClass())) {
                        InvocationHandler invoker = Proxy.getInvocationHandler(instance);
                        return invoker.invoke(instance, method, args);
                    }
                    LOG.warn((Object)("Non proxied invocation of method '" + method.getName() + "'!"));
                    return method.invoke(instance, args);
                }
                catch (IllegalAccessException iae) {
                    throw new IOException("Unable to invoke method '" + method.getName() + "'", iae);
                }
                catch (InvocationTargetException ite) {
                    throw new IOException(ite.toString(), ite);
                }
                catch (Throwable t) {
                    throw new IOException(t.toString(), t);
                }
            }
        };
    }

    public static interface Callback<R> {
        public void update(byte[] var1, byte[] var2, R var3);
    }

    public static interface Call<T, R> {
        public R call(T var1) throws IOException;
    }
}

