/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.helpers;

import java.io.File;
import org.openrdf.model.ValueFactory;
import org.openrdf.sail.Sail;
import org.openrdf.sail.SailConnection;
import org.openrdf.sail.SailException;
import org.openrdf.sail.StackableSail;

public class SailWrapper
implements StackableSail {
    private Sail baseSail;

    public SailWrapper() {
    }

    public SailWrapper(Sail baseSail) {
        this.setBaseSail(baseSail);
    }

    @Override
    public void setBaseSail(Sail baseSail) {
        this.baseSail = baseSail;
    }

    @Override
    public Sail getBaseSail() {
        return this.baseSail;
    }

    protected void verifyBaseSailSet() {
        if (this.baseSail == null) {
            throw new IllegalStateException("No base Sail has been set");
        }
    }

    @Override
    public File getDataDir() {
        return this.baseSail.getDataDir();
    }

    @Override
    public void setDataDir(File dataDir) {
        this.baseSail.setDataDir(dataDir);
    }

    @Override
    public void initialize() throws SailException {
        this.verifyBaseSailSet();
        this.baseSail.initialize();
    }

    @Override
    public void shutDown() throws SailException {
        this.verifyBaseSailSet();
        this.baseSail.shutDown();
    }

    @Override
    public boolean isWritable() throws SailException {
        this.verifyBaseSailSet();
        return this.baseSail.isWritable();
    }

    @Override
    public SailConnection getConnection() throws SailException {
        this.verifyBaseSailSet();
        return this.baseSail.getConnection();
    }

    @Override
    public ValueFactory getValueFactory() {
        this.verifyBaseSailSet();
        return this.baseSail.getValueFactory();
    }
}

