/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop;

import com.thinkaurelius.titan.diskstorage.configuration.ConfigElement;
import com.thinkaurelius.titan.hadoop.HadoopFactory;
import com.thinkaurelius.titan.hadoop.HadoopGraph;
import com.thinkaurelius.titan.hadoop.TitanIndexRepairMapper;
import com.thinkaurelius.titan.hadoop.compat.HadoopCompatLoader;
import com.thinkaurelius.titan.hadoop.compat.HadoopCompiler;
import com.thinkaurelius.titan.hadoop.config.ModifiableHadoopConfiguration;
import com.thinkaurelius.titan.hadoop.config.TitanHadoopConfiguration;
import com.thinkaurelius.titan.hadoop.formats.cassandra.TitanCassandraInputFormat;
import com.thinkaurelius.titan.hadoop.formats.hbase.TitanHBaseInputFormat;
import java.io.FileInputStream;
import java.util.Map;
import java.util.Properties;
import org.apache.cassandra.hadoop.ConfigHelper;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.lib.output.NullOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TitanIndexRepair {
    private static final Logger log = LoggerFactory.getLogger(TitanIndexRepair.class);

    public static void cassandraRepair(String titanPropertiesPath, String indexName, String indexType, String partitioner) throws Exception {
        Properties p = new Properties();
        p.load(new FileInputStream(titanPropertiesPath));
        TitanIndexRepair.cassandraRepair(p, indexName, indexType, partitioner);
    }

    public static void cassandraRepair(Properties titanProperties, String indexName, String indexType, String partitioner) throws Exception {
        Configuration hadoopConfig = new Configuration();
        ConfigHelper.setInputPartitioner((Configuration)hadoopConfig, (String)partitioner);
        ModifiableHadoopConfiguration titanConf = ModifiableHadoopConfiguration.of(hadoopConfig);
        titanConf.set(TitanHadoopConfiguration.INPUT_FORMAT, TitanCassandraInputFormat.class.getCanonicalName(), new String[0]);
        TitanIndexRepair.setCommonRepairOptions(titanConf, indexName, indexType);
        TitanIndexRepair.copyPropertiesToInputAndOutputConf(hadoopConfig, titanProperties);
        HadoopGraph hg = new HadoopGraph(hadoopConfig);
        TitanIndexRepair.repairIndex(hg);
    }

    public static void hbaseRepair(String titanPropertiesPath, String indexName, String indexType) throws Exception {
        Properties p = new Properties();
        p.load(new FileInputStream(titanPropertiesPath));
        TitanIndexRepair.hbaseRepair(p, indexName, indexType);
    }

    public static void hbaseRepair(Properties titanProperties, String indexName, String indexType) throws Exception {
        Configuration hadoopConfig = new Configuration();
        ModifiableHadoopConfiguration titanConf = ModifiableHadoopConfiguration.of(hadoopConfig);
        titanConf.set(TitanHadoopConfiguration.INPUT_FORMAT, TitanHBaseInputFormat.class.getCanonicalName(), new String[0]);
        TitanIndexRepair.setCommonRepairOptions(titanConf, indexName, indexType);
        TitanIndexRepair.copyPropertiesToInputAndOutputConf(hadoopConfig, titanProperties);
        HadoopGraph hg = new HadoopGraph(hadoopConfig);
        TitanIndexRepair.repairIndex(hg);
    }

    public static void main(String[] args) throws Exception {
        HadoopGraph hg = HadoopFactory.open(args[0]);
        TitanIndexRepair.repairIndex(hg);
    }

    public static void repairIndex(HadoopGraph hg) throws Exception {
        HadoopCompiler compiler = HadoopCompatLoader.DEFAULT_COMPAT.newCompiler(hg);
        Class<TitanIndexRepairMapper> mapper = TitanIndexRepairMapper.class;
        compiler.addMap(mapper, NullWritable.class, NullWritable.class, hg.getConf());
        compiler.completeSequence();
        compiler.run(new String[0]);
        hg.shutdown();
    }

    private static void setCommonRepairOptions(ModifiableHadoopConfiguration titanConf, String indexName, String indexType) {
        titanConf.set(TitanHadoopConfiguration.INDEX_NAME, indexName, new String[0]);
        titanConf.set(TitanHadoopConfiguration.INDEX_TYPE, indexType, new String[0]);
        log.info("Set input format {}", (Object)titanConf.get(TitanHadoopConfiguration.INPUT_FORMAT, new String[0]));
        titanConf.set(TitanHadoopConfiguration.OUTPUT_FORMAT, NullOutputFormat.class.getCanonicalName(), new String[0]);
        log.info("Set output format {}", (Object)titanConf.get(TitanHadoopConfiguration.OUTPUT_FORMAT, new String[0]));
        titanConf.set(TitanHadoopConfiguration.SIDE_EFFECT_FORMAT, TextOutputFormat.class.getCanonicalName(), new String[0]);
        titanConf.set(TitanHadoopConfiguration.JOBDIR_LOCATION, "jobs", new String[0]);
        titanConf.set(TitanHadoopConfiguration.JOBDIR_OVERWRITE, true, new String[0]);
    }

    private static void copyPropertiesToInputAndOutputConf(Configuration sink, Properties source) {
        for (Map.Entry<Object, Object> e : source.entrySet()) {
            String v = e.getValue().toString();
            String k = ConfigElement.getPath((ConfigElement)TitanHadoopConfiguration.INPUT_CONF_NS, (String[])new String[0]) + "." + e.getKey().toString();
            sink.set(k, v);
            log.info("Set {}={}", (Object)k, (Object)v);
            k = ConfigElement.getPath((ConfigElement)TitanHadoopConfiguration.OUTPUT_CONF_NS, (String[])new String[0]) + "." + e.getKey().toString();
            sink.set(k, v);
            log.info("Set {}={}", (Object)k, (Object)v);
        }
    }
}

