/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.trace.instrument.thrift;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.accumulo.trace.instrument.Span;
import org.apache.accumulo.trace.instrument.Trace;
import org.apache.accumulo.trace.thrift.TInfo;

public class RpcServerInvocationHandler<I>
implements InvocationHandler {
    private final I instance;

    protected RpcServerInvocationHandler(I serverInstance) {
        this.instance = serverInstance;
    }

    @Override
    public Object invoke(Object obj, Method method, Object[] args) throws Throwable {
        if (args == null || args.length < 1 || args[0] == null || !(args[0] instanceof TInfo)) {
            try {
                return method.invoke(this.instance, args);
            }
            catch (InvocationTargetException ex) {
                throw ex.getCause();
            }
        }
        Span span2 = Trace.trace((TInfo)args[0], method.getName());
        try {
            Object object = method.invoke(this.instance, args);
            return object;
        }
        catch (InvocationTargetException ex) {
            throw ex.getCause();
        }
        finally {
            span2.stop();
        }
    }
}

