/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.recipes.functions;

import com.google.common.base.Function;
import com.google.common.collect.Sets;
import com.netflix.astyanax.ColumnListMutation;
import com.netflix.astyanax.Keyspace;
import com.netflix.astyanax.MutationBatch;
import com.netflix.astyanax.connectionpool.exceptions.ConnectionException;
import com.netflix.astyanax.model.Column;
import com.netflix.astyanax.model.ColumnFamily;
import com.netflix.astyanax.model.Row;
import java.io.Flushable;
import java.io.IOException;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RowCopierFunction<K, C>
implements Function<Row<K, C>, Boolean>,
Flushable {
    private static final Logger LOG = LoggerFactory.getLogger(RowCopierFunction.class);
    private static final int DEFAULT_BATCH_SIZE = 100;
    private final ColumnFamily<K, C> columnFamily;
    private final Keyspace keyspace;
    private final int batchSize;
    private final ThreadLocal<ThreadContext> context = new ThreadLocal();
    private final Set<ThreadContext> contexts = Sets.newIdentityHashSet();

    public static <K, C> Builder<K, C> builder(Keyspace keyspace, ColumnFamily<K, C> columnFamily) {
        return new Builder<K, C>(keyspace, columnFamily);
    }

    private RowCopierFunction(Builder<K, C> builder) {
        this.columnFamily = ((Builder)builder).columnFamily;
        this.batchSize = ((Builder)builder).batchSize;
        this.keyspace = ((Builder)builder).keyspace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean apply(Row<K, C> row) {
        ThreadContext context = this.context.get();
        if (context == null) {
            context = new ThreadContext();
            context.mb = this.keyspace.prepareMutationBatch();
            this.context.set(context);
            RowCopierFunction rowCopierFunction = this;
            synchronized (rowCopierFunction) {
                this.contexts.add(context);
            }
        }
        ColumnListMutation mbRow = context.mb.withRow(this.columnFamily, row.getKey());
        context.mb.lockCurrentTimestamp();
        for (Column column : row.getColumns()) {
            mbRow.setTimestamp(column.getTimestamp());
            mbRow.putColumn(column.getName(), column.getByteBufferValue(), Integer.valueOf(column.getTtl()));
        }
        ++context.counter;
        if (context.counter == this.batchSize) {
            try {
                context.mb.execute();
                context.counter = 0;
            }
            catch (Exception e) {
                LOG.error("Failed to write mutation", (Throwable)e);
                return false;
            }
        }
        return true;
    }

    @Override
    public void flush() throws IOException {
        for (ThreadContext context : this.contexts) {
            try {
                context.mb.execute();
            }
            catch (ConnectionException e) {
                LOG.error("Failed to write mutation", (Throwable)e);
            }
        }
    }

    private static class ThreadContext {
        MutationBatch mb;
        int counter = 0;

        private ThreadContext() {
        }
    }

    public static class Builder<K, C> {
        private final ColumnFamily<K, C> columnFamily;
        private final Keyspace keyspace;
        private int batchSize = 100;

        public Builder(Keyspace keyspace, ColumnFamily<K, C> columnFamily) {
            this.columnFamily = columnFamily;
            this.keyspace = keyspace;
        }

        public Builder<K, C> withBatchSize(int batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public RowCopierFunction<K, C> build() {
            return new RowCopierFunction(this);
        }
    }
}

