/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.accumulo.blueprints;

import java.util.Map;
import org.vertexium.Graph;
import org.vertexium.GraphConfiguration;
import org.vertexium.VertexiumException;
import org.vertexium.accumulo.AccumuloGraph;
import org.vertexium.accumulo.blueprints.AccumuloVertexiumBlueprintsGraph;
import org.vertexium.blueprints.AuthorizationsProvider;
import org.vertexium.blueprints.DefaultVisibilityProvider;
import org.vertexium.blueprints.VertexiumBlueprintsFactory;
import org.vertexium.blueprints.VertexiumBlueprintsGraph;
import org.vertexium.blueprints.VisibilityProvider;
import org.vertexium.util.ConfigurationUtils;
import org.vertexium.util.MapUtils;

public class AccumuloVertexiumBlueprintsGraphFactory
extends VertexiumBlueprintsFactory {
    public VertexiumBlueprintsGraph createGraph(Map config) {
        AccumuloGraph graph = this.createAccumuloGraph(config);
        VisibilityProvider visibilityProvider = this.createVisibilityProvider(graph, (GraphConfiguration)graph.getConfiguration());
        AuthorizationsProvider authorizationProvider = this.createAuthorizationsProvider(graph, (GraphConfiguration)graph.getConfiguration());
        return new AccumuloVertexiumBlueprintsGraph(graph, visibilityProvider, authorizationProvider);
    }

    private AccumuloGraph createAccumuloGraph(Map config) {
        try {
            Map graphConfig = MapUtils.getAllWithPrefix((Map)config, (String)"graph");
            return AccumuloGraph.create((Map)graphConfig);
        }
        catch (Exception ex) {
            throw new VertexiumException("Could not create accumulo graph", (Throwable)ex);
        }
    }

    private VisibilityProvider createVisibilityProvider(AccumuloGraph graph, GraphConfiguration config) {
        try {
            return (VisibilityProvider)ConfigurationUtils.createProvider((Graph)graph, (GraphConfiguration)config, (String)"visibilityProvider", (String)DefaultVisibilityProvider.class.getName());
        }
        catch (Exception ex) {
            throw new VertexiumException("Could not create visibility provider", (Throwable)ex);
        }
    }

    private AuthorizationsProvider createAuthorizationsProvider(AccumuloGraph graph, GraphConfiguration config) {
        try {
            return (AuthorizationsProvider)ConfigurationUtils.createProvider((Graph)graph, (GraphConfiguration)config, (String)"authorizationsProvider", null);
        }
        catch (Exception ex) {
            throw new VertexiumException("Could not create authorization provider", (Throwable)ex);
        }
    }
}

