/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.pipes.transform;

import com.tinkerpop.pipes.AbstractPipe;
import com.tinkerpop.pipes.Pipe;
import com.tinkerpop.pipes.PipeFunction;
import com.tinkerpop.pipes.transform.TransformPipe;
import com.tinkerpop.pipes.util.PipesPipeline;
import com.tinkerpop.pipes.util.StartPipe;
import com.tinkerpop.pipes.util.iterators.EmptyIterator;
import com.tinkerpop.pipes.util.structures.Pair;
import java.util.Map;

public class OrderMapPipe<S>
extends AbstractPipe<Map<S, ?>, S>
implements TransformPipe<Map<S, ?>, S> {
    private Pipe pipe = new StartPipe(EmptyIterator.INSTANCE);
    private final PipeFunction<Pair<Map.Entry<S, ?>, Map.Entry<S, ?>>, Integer> compareFunction;

    public OrderMapPipe(PipeFunction<Pair<Map.Entry<S, ?>, Map.Entry<S, ?>>, Integer> compareFunction) {
        this.compareFunction = compareFunction;
    }

    public OrderMapPipe(TransformPipe.Order order) {
        this.compareFunction = order.equals((Object)TransformPipe.Order.DECR) ? new IncrementFunction() : new DecrementFunction();
    }

    @Override
    public S processNextStart() {
        while (!this.pipe.hasNext()) {
            this.pipe = ((PipesPipeline)new PipesPipeline(((Map)this.starts.next()).entrySet()).order(this.compareFunction)).transform(new PipeFunction<Map.Entry, Object>(){

                @Override
                public Object compute(Map.Entry entry) {
                    return entry.getKey();
                }
            });
        }
        return (S)this.pipe.next();
    }

    private class IncrementFunction
    implements PipeFunction<Pair<Map.Entry<S, ?>, Map.Entry<S, ?>>, Integer> {
        private IncrementFunction() {
        }

        @Override
        public Integer compute(Pair<Map.Entry<S, ?>, Map.Entry<S, ?>> pair) {
            return ((Comparable)pair.getB().getValue()).compareTo(pair.getA().getValue());
        }
    }

    private class DecrementFunction
    implements PipeFunction<Pair<Map.Entry<S, ?>, Map.Entry<S, ?>>, Integer> {
        private DecrementFunction() {
        }

        @Override
        public Integer compute(Pair<Map.Entry<S, ?>, Map.Entry<S, ?>> pair) {
            return ((Comparable)pair.getA().getValue()).compareTo(pair.getB().getValue());
        }
    }
}

