/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.vertexium.VertexiumException;
import org.vertexium.Visibility;

public class Metadata
implements Serializable {
    static final long serialVersionUID = 42L;
    private Map<String, Entry> entries = new HashMap<String, Entry>();
    public static final String KEY_SEPARATOR = "\u001f";

    public Metadata add(String key, Object value, Visibility visibility) {
        this.entries.put(this.toMapKey(key, visibility), new Entry(key, value, visibility));
        return this;
    }

    public void remove(String key, Visibility visibility) {
        this.entries.remove(this.toMapKey(key, visibility));
    }

    public void clear() {
        this.entries.clear();
    }

    public void remove(String key) {
        for (Map.Entry<String, Entry> e : new ArrayList<Map.Entry<String, Entry>>(this.entries.entrySet())) {
            if (!e.getValue().getKey().equals(key)) continue;
            this.entries.remove(e.getKey());
        }
    }

    public Collection<Entry> entrySet() {
        return this.entries.values();
    }

    public Entry getEntry(String key, Visibility visibility) {
        return this.entries.get(this.toMapKey(key, visibility));
    }

    public Entry getEntry(String key) {
        Entry entry = null;
        for (Map.Entry<String, Entry> e : this.entries.entrySet()) {
            if (!e.getValue().getKey().equals(key)) continue;
            if (entry != null) {
                throw new VertexiumException("Multiple matching entries for key: " + key);
            }
            entry = e.getValue();
        }
        return entry;
    }

    public Collection<Entry> getEntries(String key) {
        ArrayList<Entry> results = new ArrayList<Entry>();
        for (Map.Entry<String, Entry> e : this.entries.entrySet()) {
            if (!e.getValue().getKey().equals(key)) continue;
            Entry entry = e.getValue();
            results.add(entry);
        }
        return results;
    }

    public Object getValue(String key, Visibility visibility) {
        Entry entry = this.getEntry(key, visibility);
        if (entry == null) {
            return null;
        }
        return entry.getValue();
    }

    public Object getValue(String key) {
        Entry entry = this.getEntry(key);
        if (entry == null) {
            return null;
        }
        return entry.getValue();
    }

    public Collection<Object> getValues(String key) {
        ArrayList<Object> results = new ArrayList<Object>();
        Collection<Entry> entries = this.getEntries(key);
        for (Entry entry : entries) {
            results.add(entry.getValue());
        }
        return results;
    }

    public boolean containsKey(String key) {
        for (Map.Entry<String, Entry> e : this.entries.entrySet()) {
            if (!e.getValue().getKey().equals(key)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(String key, Visibility visibility) {
        return this.getEntry(key, visibility) != null;
    }

    private String toMapKey(String key, Visibility visibility) {
        return key + KEY_SEPARATOR + visibility.getVisibilityString();
    }

    public static class Entry
    implements Serializable {
        static final long serialVersionUID = 42L;
        private final String key;
        private final Object value;
        private final Visibility visibility;

        private Entry(String key, Object value, Visibility visibility) {
            this.key = key;
            this.value = value;
            this.visibility = visibility;
        }

        public String getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Visibility getVisibility() {
            return this.visibility;
        }

        public String toString() {
            return "Entry{key='" + this.key + '\'' + ", value=" + this.value + ", visibility=" + this.visibility + '}';
        }
    }
}

