/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.elasticsearch;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.vertexium.Visibility;

public class IndexInfo {
    private final String indexName;
    private boolean elementTypeDefined;
    private Map<String, PropertyInfo> propertyInfos = new HashMap<String, PropertyInfo>();

    public IndexInfo(String indexName) {
        this.indexName = indexName;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public int hashCode() {
        return this.getIndexName().hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof IndexInfo)) {
            return false;
        }
        IndexInfo otherIndexInfo = (IndexInfo)obj;
        return this.getIndexName().equals(otherIndexInfo.getIndexName());
    }

    public boolean isElementTypeDefined() {
        return this.elementTypeDefined;
    }

    public void setElementTypeDefined(boolean elementTypeDefined) {
        this.elementTypeDefined = elementTypeDefined;
    }

    public void addPropertyNameVisibility(String propertyName, Visibility visibility) {
        PropertyInfo propertyInfo = this.propertyInfos.get(propertyName);
        if (propertyInfo == null) {
            propertyInfo = new PropertyInfo();
            this.propertyInfos.put(propertyName, propertyInfo);
        }
        propertyInfo.addVisibility(visibility);
    }

    public boolean isPropertyDefined(String propertyName, Visibility visibility) {
        PropertyInfo propertyInfo = this.propertyInfos.get(propertyName);
        if (propertyInfo == null) {
            return false;
        }
        return propertyInfo.hasVisibility(visibility);
    }

    public boolean isPropertyDefined(String propertyName) {
        PropertyInfo propertyInfo = this.propertyInfos.get(propertyName);
        return propertyInfo != null;
    }

    private static class PropertyInfo {
        private Set<Visibility> visibilities = new HashSet<Visibility>();

        private PropertyInfo() {
        }

        public void addVisibility(Visibility visibility) {
            this.visibilities.add(visibility);
        }

        public boolean hasVisibility(Visibility visibility) {
            return this.visibilities.contains(visibility);
        }
    }
}

