/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.frames.annotations;

import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.frames.ClassUtilities;
import com.tinkerpop.frames.FramedGraph;
import com.tinkerpop.frames.Property;
import com.tinkerpop.frames.annotations.AnnotationHandler;
import java.lang.reflect.Method;

public class PropertyAnnotationHandler
implements AnnotationHandler<Property> {
    @Override
    public Class<Property> getAnnotationType() {
        return Property.class;
    }

    @Override
    public Object processElement(Property annotation, Method method, Object[] arguments, FramedGraph framedGraph, Element element, Direction direction) {
        if (ClassUtilities.isGetMethod(method)) {
            Object value = element.getProperty(annotation.value());
            if (method.getReturnType().isEnum()) {
                return this.getValueAsEnum(method, value);
            }
            return value;
        }
        if (ClassUtilities.isSetMethod(method)) {
            Object value = arguments[0];
            if (null == value) {
                element.removeProperty(annotation.value());
            } else if (value.getClass().isEnum()) {
                element.setProperty(annotation.value(), (Object)((Enum)value).name());
            } else {
                element.setProperty(annotation.value(), value);
            }
            return null;
        }
        if (ClassUtilities.isRemoveMethod(method)) {
            element.removeProperty(annotation.value());
            return null;
        }
        return null;
    }

    private Enum getValueAsEnum(Method method, Object value) {
        Class<?> en = method.getReturnType();
        if (value != null) {
            return Enum.valueOf(en, value.toString());
        }
        return null;
    }
}

