/*
 * Decompiled with CFR 0.152.
 */
package org.semarglproject.sesame.rdf.rdfa;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import org.openrdf.model.ValueFactory;
import org.openrdf.rio.ParseErrorListener;
import org.openrdf.rio.ParseLocationListener;
import org.openrdf.rio.ParserConfig;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;
import org.openrdf.rio.RDFParser;
import org.semarglproject.rdf.ParseException;
import org.semarglproject.rdf.ProcessorGraphHandler;
import org.semarglproject.rdf.rdfa.RdfaParser;
import org.semarglproject.sesame.core.sink.SesameSink;
import org.semarglproject.sesame.rdf.rdfa.RDFaFormat;
import org.semarglproject.sesame.rdf.rdfa.RdfaParserConfig;
import org.semarglproject.sink.DataSink;
import org.semarglproject.sink.TripleSink;
import org.semarglproject.source.StreamProcessor;

public final class SesameRDFaParser
implements RDFParser,
ProcessorGraphHandler {
    private boolean processorGraphEnabled = false;
    private boolean vocabExpansionEnabled = false;
    private boolean preserveBNodeIDs = true;
    private short rdfaCompatibility = (short)2;
    private final StreamProcessor streamProcessor = new StreamProcessor((DataSink)RdfaParser.connect((TripleSink)SesameSink.connect(null)));
    private ParseErrorListener parseErrorListener = null;

    public SesameRDFaParser() {
        this.streamProcessor.setProperty("http://semarglproject.org/rdfa/properties/enable-processor-graph", (Object)this.processorGraphEnabled);
        this.streamProcessor.setProperty("http://semarglproject.org/rdfa/properties/enable-vocab-expansion", (Object)this.vocabExpansionEnabled);
        this.streamProcessor.setProperty("http://semarglproject.org/core/properties/processor-graph-handler", (Object)this);
    }

    public RDFFormat getRDFFormat() {
        return RDFaFormat.RDFA;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(InputStream in, String baseURI) throws RDFParseException, RDFHandlerException {
        InputStreamReader reader = new InputStreamReader(in, Charset.forName("UTF-8"));
        try {
            this.parse(reader, baseURI);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e) {}
        }
    }

    public void parse(Reader reader, String baseURI) throws RDFParseException, RDFHandlerException {
        try {
            this.streamProcessor.process(reader, baseURI);
        }
        catch (ParseException e) {
            throw new RDFParseException((Throwable)e);
        }
    }

    public void setValueFactory(ValueFactory valueFactory) {
        this.streamProcessor.setProperty("http://semarglproject.org/sesame/properties/value-factory", (Object)valueFactory);
    }

    public void setRDFHandler(RDFHandler handler) {
        this.streamProcessor.setProperty("http://semarglproject.org/sesame/properties/rdf-handler", (Object)handler);
    }

    public void setParseErrorListener(ParseErrorListener el) {
        this.parseErrorListener = el;
    }

    public void setParseLocationListener(ParseLocationListener ll) {
    }

    public void setParserConfig(ParserConfig config) {
        if (config instanceof RdfaParserConfig) {
            RdfaParserConfig rdfaParserConfig = (RdfaParserConfig)config;
            this.setProcessorGraphEnabled(rdfaParserConfig.isProcessorGraphEnabled());
            this.setVocabExpansionEnabled(rdfaParserConfig.isVocabExpansionEnabled());
            this.setRdfaCompatibility(rdfaParserConfig.getRdfaCompatibility());
        }
        this.preserveBNodeIDs = config.isPreserveBNodeIDs();
    }

    public RdfaParserConfig getParserConfig() {
        return new RdfaParserConfig(false, false, this.preserveBNodeIDs, RDFParser.DatatypeHandling.IGNORE, this.processorGraphEnabled, this.vocabExpansionEnabled, this.rdfaCompatibility);
    }

    public void setVerifyData(boolean verifyData) {
    }

    public void setPreserveBNodeIDs(boolean preserveBNodeIDs) {
        this.preserveBNodeIDs = preserveBNodeIDs;
    }

    public void setStopAtFirstError(boolean stopAtFirstError) {
    }

    public void setDatatypeHandling(RDFParser.DatatypeHandling datatypeHandling) {
        if (!datatypeHandling.equals((Object)RDFParser.DatatypeHandling.IGNORE)) {
            throw new IllegalArgumentException("Parser doesn't support datatypeHandling = " + datatypeHandling.name());
        }
    }

    public void setProcessorGraphEnabled(boolean processorGraphEnabled) {
        this.processorGraphEnabled = processorGraphEnabled;
        this.streamProcessor.setProperty("http://semarglproject.org/rdfa/properties/enable-processor-graph", (Object)processorGraphEnabled);
    }

    public void setVocabExpansionEnabled(boolean vocabExpansionEnabled) {
        this.vocabExpansionEnabled = vocabExpansionEnabled;
        this.streamProcessor.setProperty("http://semarglproject.org/rdfa/properties/enable-vocab-expansion", (Object)vocabExpansionEnabled);
    }

    public void setRdfaCompatibility(short rdfaCompatibility) {
        this.rdfaCompatibility = rdfaCompatibility;
        this.streamProcessor.setProperty("http://semarglproject.org/rdfa/properties/version", (Object)rdfaCompatibility);
    }

    public void info(String infoClass, String message) {
    }

    public void warning(String warningClass, String message) {
        if (this.parseErrorListener != null) {
            this.parseErrorListener.warning(message, -1, -1);
        }
    }

    public void error(String errorClass, String message) {
        if (this.parseErrorListener != null) {
            this.parseErrorListener.error(message, -1, -1);
        }
    }
}

