/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.junitbenchmarks;

import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.List;

public final class GCSnapshot {
    private static List<GarbageCollectorMXBean> garbageBeans = ManagementFactory.getGarbageCollectorMXBeans();
    private long[] gcInvocations = new long[garbageBeans.size()];
    private long[] gcTimes = new long[garbageBeans.size()];

    GCSnapshot() {
        for (int i = 0; i < this.gcInvocations.length; ++i) {
            this.gcInvocations[i] = garbageBeans.get(i).getCollectionCount();
            this.gcTimes[i] = garbageBeans.get(i).getCollectionTime();
        }
    }

    public long accumulatedInvocations() {
        long sum = 0L;
        int i = 0;
        for (GarbageCollectorMXBean bean : garbageBeans) {
            sum += bean.getCollectionCount() - this.gcInvocations[i++];
        }
        return sum;
    }

    public long accumulatedTime() {
        long sum = 0L;
        int i = 0;
        for (GarbageCollectorMXBean bean : garbageBeans) {
            sum += bean.getCollectionTime() - this.gcTimes[i++];
        }
        return sum;
    }
}

