/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.search.ClearScrollRequest;
import org.elasticsearch.action.search.ClearScrollResponse;
import org.elasticsearch.action.search.type.TransportSearchHelper;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.CountDown;
import org.elasticsearch.search.action.SearchServiceTransportAction;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportClearScrollAction
extends HandledTransportAction<ClearScrollRequest, ClearScrollResponse> {
    private final ClusterService clusterService;
    private final SearchServiceTransportAction searchServiceTransportAction;

    @Inject
    public TransportClearScrollAction(Settings settings, TransportService transportService, ThreadPool threadPool, ClusterService clusterService, SearchServiceTransportAction searchServiceTransportAction, ActionFilters actionFilters) {
        super(settings, "indices:data/read/scroll/clear", threadPool, transportService, actionFilters);
        this.clusterService = clusterService;
        this.searchServiceTransportAction = searchServiceTransportAction;
    }

    @Override
    protected void doExecute(ClearScrollRequest request, ActionListener<ClearScrollResponse> listener) {
        new Async(request, listener, this.clusterService.state()).run();
    }

    @Override
    public ClearScrollRequest newRequestInstance() {
        return new ClearScrollRequest();
    }

    private class Async {
        final DiscoveryNodes nodes;
        final CountDown expectedOps;
        final ClearScrollRequest request;
        final List<Tuple<String, Long>[]> contexts = new ArrayList<Tuple<String, Long>[]>();
        final ActionListener<ClearScrollResponse> listener;
        final AtomicReference<Throwable> expHolder;
        final AtomicInteger numberOfFreedSearchContexts = new AtomicInteger(0);

        private Async(ClearScrollRequest request, ActionListener<ClearScrollResponse> listener, ClusterState clusterState) {
            int expectedOps = 0;
            this.nodes = clusterState.nodes();
            if (request.getScrollIds().size() == 1 && "_all".equals(request.getScrollIds().get(0))) {
                expectedOps = this.nodes.size();
            } else {
                for (String parsedScrollId : request.getScrollIds()) {
                    Tuple<String, Long>[] context = TransportSearchHelper.parseScrollId(parsedScrollId).getContext();
                    expectedOps += context.length;
                    this.contexts.add(context);
                }
            }
            this.request = request;
            this.listener = listener;
            this.expHolder = new AtomicReference();
            this.expectedOps = new CountDown(expectedOps);
        }

        public void run() {
            if (this.expectedOps.isCountedDown()) {
                this.listener.onResponse(new ClearScrollResponse(true, 0));
                return;
            }
            if (this.contexts.isEmpty()) {
                for (final DiscoveryNode node : this.nodes) {
                    TransportClearScrollAction.this.searchServiceTransportAction.sendClearAllScrollContexts(node, this.request, new ActionListener<Boolean>(){

                        @Override
                        public void onResponse(Boolean freed) {
                            Async.this.onFreedContext(freed);
                        }

                        @Override
                        public void onFailure(Throwable e) {
                            Async.this.onFailedFreedContext(e, node);
                        }
                    });
                }
            } else {
                for (Tuple<String, Long>[] context : this.contexts) {
                    for (Tuple<String, Long> target : context) {
                        final DiscoveryNode node = this.nodes.get(target.v1());
                        if (node == null) {
                            this.onFreedContext(false);
                            continue;
                        }
                        TransportClearScrollAction.this.searchServiceTransportAction.sendFreeContext(node, target.v2(), this.request, new ActionListener<Boolean>(){

                            @Override
                            public void onResponse(Boolean freed) {
                                Async.this.onFreedContext(freed);
                            }

                            @Override
                            public void onFailure(Throwable e) {
                                Async.this.onFailedFreedContext(e, node);
                            }
                        });
                    }
                }
            }
        }

        void onFreedContext(boolean freed) {
            if (freed) {
                this.numberOfFreedSearchContexts.incrementAndGet();
            }
            if (this.expectedOps.countDown()) {
                boolean succeeded = this.expHolder.get() == null;
                this.listener.onResponse(new ClearScrollResponse(succeeded, this.numberOfFreedSearchContexts.get()));
            }
        }

        void onFailedFreedContext(Throwable e, DiscoveryNode node) {
            TransportClearScrollAction.this.logger.warn("Clear SC failed on node[{}]", e, node);
            if (this.expectedOps.countDown()) {
                this.listener.onResponse(new ClearScrollResponse(false, this.numberOfFreedSearchContexts.get()));
            } else {
                this.expHolder.set(e);
            }
        }
    }
}

