/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium;

import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.vertexium.Authorizations;
import org.vertexium.DefinePropertyBuilder;
import org.vertexium.Edge;
import org.vertexium.EdgeBuilder;
import org.vertexium.EdgeBuilderByVertexId;
import org.vertexium.ElementBuilder;
import org.vertexium.ElementFilter;
import org.vertexium.FetchHint;
import org.vertexium.GraphMetadataEntry;
import org.vertexium.Path;
import org.vertexium.ProgressCallback;
import org.vertexium.PropertyDefinition;
import org.vertexium.Range;
import org.vertexium.RelatedEdge;
import org.vertexium.SearchIndexSecurityGranularity;
import org.vertexium.Vertex;
import org.vertexium.VertexBuilder;
import org.vertexium.Visibility;
import org.vertexium.event.GraphEventListener;
import org.vertexium.id.IdGenerator;
import org.vertexium.query.GraphQuery;
import org.vertexium.query.MultiVertexQuery;
import org.vertexium.query.SimilarToGraphQuery;

public interface Graph {
    public Vertex addVertex(Visibility var1, Authorizations var2);

    public Vertex addVertex(String var1, Visibility var2, Authorizations var3);

    public Iterable<Vertex> addVertices(Iterable<ElementBuilder<Vertex>> var1, Authorizations var2);

    public VertexBuilder prepareVertex(Visibility var1);

    public VertexBuilder prepareVertex(Long var1, Visibility var2);

    public VertexBuilder prepareVertex(String var1, Visibility var2);

    public VertexBuilder prepareVertex(String var1, Long var2, Visibility var3);

    public boolean doesVertexExist(String var1, Authorizations var2);

    public Vertex getVertex(String var1, Authorizations var2);

    public Vertex getVertex(String var1, EnumSet<FetchHint> var2, Authorizations var3);

    public Vertex getVertex(String var1, EnumSet<FetchHint> var2, Long var3, Authorizations var4);

    public Iterable<Vertex> getVerticesWithPrefix(String var1, Authorizations var2);

    public Iterable<Vertex> getVerticesWithPrefix(String var1, EnumSet<FetchHint> var2, Authorizations var3);

    public Iterable<Vertex> getVerticesWithPrefix(String var1, EnumSet<FetchHint> var2, Long var3, Authorizations var4);

    public Iterable<Vertex> getVerticesInRange(Range var1, Authorizations var2);

    public Iterable<Vertex> getVerticesInRange(Range var1, EnumSet<FetchHint> var2, Authorizations var3);

    public Iterable<Vertex> getVerticesInRange(Range var1, EnumSet<FetchHint> var2, Long var3, Authorizations var4);

    public Iterable<Vertex> getVertices(Authorizations var1);

    public Iterable<Vertex> getVertices(EnumSet<FetchHint> var1, Authorizations var2);

    public Iterable<Vertex> getVertices(EnumSet<FetchHint> var1, Long var2, Authorizations var3);

    public Map<String, Boolean> doVerticesExist(Iterable<String> var1, Authorizations var2);

    public Iterable<Vertex> getVertices(Iterable<String> var1, Authorizations var2);

    public Iterable<Vertex> getVertices(Iterable<String> var1, EnumSet<FetchHint> var2, Authorizations var3);

    public Iterable<Vertex> getVertices(Iterable<String> var1, EnumSet<FetchHint> var2, Long var3, Authorizations var4);

    public List<Vertex> getVerticesInOrder(Iterable<String> var1, Authorizations var2);

    public List<Vertex> getVerticesInOrder(Iterable<String> var1, EnumSet<FetchHint> var2, Authorizations var3);

    public void deleteVertex(Vertex var1, Authorizations var2);

    public void deleteVertex(String var1, Authorizations var2);

    public void softDeleteVertex(Vertex var1, Authorizations var2);

    public void softDeleteVertex(Vertex var1, Long var2, Authorizations var3);

    public void softDeleteVertex(String var1, Authorizations var2);

    public void softDeleteVertex(String var1, Long var2, Authorizations var3);

    public Edge addEdge(Vertex var1, Vertex var2, String var3, Visibility var4, Authorizations var5);

    public Edge addEdge(String var1, Vertex var2, Vertex var3, String var4, Visibility var5, Authorizations var6);

    public Edge addEdge(String var1, String var2, String var3, Visibility var4, Authorizations var5);

    public Edge addEdge(String var1, String var2, String var3, String var4, Visibility var5, Authorizations var6);

    public EdgeBuilder prepareEdge(Vertex var1, Vertex var2, String var3, Visibility var4);

    public EdgeBuilder prepareEdge(String var1, Vertex var2, Vertex var3, String var4, Visibility var5);

    public EdgeBuilder prepareEdge(String var1, Vertex var2, Vertex var3, String var4, Long var5, Visibility var6);

    public EdgeBuilderByVertexId prepareEdge(String var1, String var2, String var3, Visibility var4);

    public EdgeBuilderByVertexId prepareEdge(String var1, String var2, String var3, String var4, Visibility var5);

    public EdgeBuilderByVertexId prepareEdge(String var1, String var2, String var3, String var4, Long var5, Visibility var6);

    public boolean doesEdgeExist(String var1, Authorizations var2);

    public Edge getEdge(String var1, Authorizations var2);

    public Edge getEdge(String var1, EnumSet<FetchHint> var2, Authorizations var3);

    public Edge getEdge(String var1, EnumSet<FetchHint> var2, Long var3, Authorizations var4);

    public Iterable<Edge> getEdges(Authorizations var1);

    public Iterable<Edge> getEdges(EnumSet<FetchHint> var1, Authorizations var2);

    public Iterable<Edge> getEdges(EnumSet<FetchHint> var1, Long var2, Authorizations var3);

    public Iterable<Edge> getEdgesInRange(Range var1, Authorizations var2);

    public Iterable<Edge> getEdgesInRange(Range var1, EnumSet<FetchHint> var2, Authorizations var3);

    public Iterable<Edge> getEdgesInRange(Range var1, EnumSet<FetchHint> var2, Long var3, Authorizations var4);

    public Iterable<String> filterEdgeIdsByAuthorization(Iterable<String> var1, String var2, EnumSet<ElementFilter> var3, Authorizations var4);

    public Iterable<String> filterVertexIdsByAuthorization(Iterable<String> var1, String var2, EnumSet<ElementFilter> var3, Authorizations var4);

    public Map<String, Boolean> doEdgesExist(Iterable<String> var1, Authorizations var2);

    public Map<String, Boolean> doEdgesExist(Iterable<String> var1, Long var2, Authorizations var3);

    public Iterable<Edge> getEdges(Iterable<String> var1, Authorizations var2);

    public Iterable<Edge> getEdges(Iterable<String> var1, EnumSet<FetchHint> var2, Authorizations var3);

    public Iterable<Edge> getEdges(Iterable<String> var1, EnumSet<FetchHint> var2, Long var3, Authorizations var4);

    @Deprecated
    public Iterable<String> findRelatedEdges(Iterable<String> var1, Authorizations var2);

    @Deprecated
    public Iterable<String> findRelatedEdges(Iterable<String> var1, Long var2, Authorizations var3);

    public Iterable<String> findRelatedEdgeIdsForVertices(Iterable<Vertex> var1, Authorizations var2);

    public Iterable<String> findRelatedEdgeIds(Iterable<String> var1, Authorizations var2);

    public Iterable<String> findRelatedEdgeIds(Iterable<String> var1, Long var2, Authorizations var3);

    public Iterable<RelatedEdge> findRelatedEdgeSummaryForVertices(Iterable<Vertex> var1, Authorizations var2);

    public Iterable<RelatedEdge> findRelatedEdgeSummary(Iterable<String> var1, Authorizations var2);

    public Iterable<RelatedEdge> findRelatedEdgeSummary(Iterable<String> var1, Long var2, Authorizations var3);

    public void deleteEdge(Edge var1, Authorizations var2);

    public void deleteEdge(String var1, Authorizations var2);

    public void softDeleteEdge(Edge var1, Authorizations var2);

    public void softDeleteEdge(Edge var1, Long var2, Authorizations var3);

    public void softDeleteEdge(String var1, Authorizations var2);

    public void softDeleteEdge(String var1, Long var2, Authorizations var3);

    public GraphQuery query(String var1, Authorizations var2);

    public GraphQuery query(Authorizations var1);

    public MultiVertexQuery query(String[] var1, String var2, Authorizations var3);

    public MultiVertexQuery query(String[] var1, Authorizations var2);

    public boolean isQuerySimilarToTextSupported();

    public SimilarToGraphQuery querySimilarTo(String[] var1, String var2, Authorizations var3);

    public void flush();

    public void shutdown();

    public Iterable<Path> findPaths(String var1, String var2, int var3, Authorizations var4);

    public Iterable<Path> findPaths(String var1, String var2, String[] var3, int var4, Authorizations var5);

    public Iterable<Path> findPaths(String var1, String var2, int var3, ProgressCallback var4, Authorizations var5);

    public Iterable<Path> findPaths(String var1, String var2, String[] var3, int var4, ProgressCallback var5, Authorizations var6);

    public IdGenerator getIdGenerator();

    public boolean isVisibilityValid(Visibility var1, Authorizations var2);

    public void reindex(Authorizations var1);

    public void setMetadata(String var1, Object var2);

    public Object getMetadata(String var1);

    public Iterable<GraphMetadataEntry> getMetadata();

    public Iterable<GraphMetadataEntry> getMetadataWithPrefix(String var1);

    public boolean isFieldBoostSupported();

    public void truncate();

    public void drop();

    public SearchIndexSecurityGranularity getSearchIndexSecurityGranularity();

    public void addGraphEventListener(GraphEventListener var1);

    public void markVertexHidden(Vertex var1, Visibility var2, Authorizations var3);

    public void markVertexVisible(Vertex var1, Visibility var2, Authorizations var3);

    public void markEdgeHidden(Edge var1, Visibility var2, Authorizations var3);

    public void markEdgeVisible(Edge var1, Visibility var2, Authorizations var3);

    public Authorizations createAuthorizations(String ... var1);

    public Authorizations createAuthorizations(Collection<String> var1);

    public Authorizations createAuthorizations(Authorizations var1, String ... var2);

    public Authorizations createAuthorizations(Authorizations var1, Collection<String> var2);

    public Map<Object, Long> getVertexPropertyCountByValue(String var1, Authorizations var2);

    public long getVertexCount(Authorizations var1);

    public long getEdgeCount(Authorizations var1);

    public void savePropertyDefinition(PropertyDefinition var1);

    public DefinePropertyBuilder defineProperty(String var1);

    public boolean isPropertyDefined(String var1);

    public PropertyDefinition getPropertyDefinition(String var1);

    public Collection<PropertyDefinition> getPropertyDefinitions();
}

