/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop.mapreduce.filter;

import com.thinkaurelius.titan.hadoop.FaunusVertex;
import com.thinkaurelius.titan.hadoop.StandardFaunusEdge;
import com.thinkaurelius.titan.hadoop.Tokens;
import com.thinkaurelius.titan.hadoop.compat.HadoopCompatLoader;
import com.thinkaurelius.titan.hadoop.mapreduce.util.ElementChecker;
import com.thinkaurelius.titan.hadoop.mapreduce.util.EmptyConfiguration;
import com.tinkerpop.blueprints.Compare;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Vertex;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;

public class IntervalFilterMap {
    public static final String CLASS = Tokens.makeNamespace(IntervalFilterMap.class) + ".class";
    public static final String KEY = Tokens.makeNamespace(IntervalFilterMap.class) + ".key";
    public static final String START_VALUE = Tokens.makeNamespace(IntervalFilterMap.class) + ".startValue";
    public static final String END_VALUE = Tokens.makeNamespace(IntervalFilterMap.class) + ".endValue";
    public static final String VALUE_CLASS = Tokens.makeNamespace(IntervalFilterMap.class) + ".valueClass";

    public static Configuration createConfiguration(Class<? extends Element> klass, String key, Object startValue, Object endValue) {
        EmptyConfiguration configuration = new EmptyConfiguration();
        configuration.setClass(CLASS, klass, Element.class);
        configuration.set(KEY, key);
        if (startValue instanceof String) {
            configuration.set(VALUE_CLASS, String.class.getName());
            configuration.set(START_VALUE, (String)startValue);
            configuration.set(END_VALUE, (String)endValue);
        } else if (startValue instanceof Number) {
            configuration.set(VALUE_CLASS, Float.class.getName());
            configuration.setFloat(START_VALUE, ((Number)startValue).floatValue());
            configuration.setFloat(END_VALUE, ((Number)endValue).floatValue());
        } else if (startValue instanceof Boolean) {
            configuration.set(VALUE_CLASS, Boolean.class.getName());
            configuration.setBoolean(START_VALUE, (Boolean)startValue);
            configuration.setBoolean(END_VALUE, (Boolean)endValue);
        } else {
            throw new RuntimeException("Unknown value class: " + startValue.getClass().getName());
        }
        return configuration;
    }

    public static class Map
    extends Mapper<NullWritable, FaunusVertex, NullWritable, FaunusVertex> {
        private boolean isVertex;
        private ElementChecker startChecker;
        private ElementChecker endChecker;

        public void setup(Mapper.Context context) throws IOException, InterruptedException {
            Object endValue;
            Object startValue;
            Configuration cfg = HadoopCompatLoader.DEFAULT_COMPAT.getContextConfiguration((TaskAttemptContext)context);
            this.isVertex = cfg.getClass(CLASS, Element.class, Element.class).equals(Vertex.class);
            String key = cfg.get(KEY);
            Class valueClass = cfg.getClass(VALUE_CLASS, String.class);
            if (valueClass.equals(String.class)) {
                startValue = cfg.get(START_VALUE);
                endValue = cfg.get(END_VALUE);
            } else if (Number.class.isAssignableFrom(valueClass)) {
                startValue = Float.valueOf(cfg.getFloat(START_VALUE, Float.MIN_VALUE));
                endValue = Float.valueOf(cfg.getFloat(END_VALUE, Float.MAX_VALUE));
            } else {
                throw new IOException("Class " + valueClass + " is an unsupported value class");
            }
            this.startChecker = new ElementChecker(key, Compare.GREATER_THAN_EQUAL, startValue);
            this.endChecker = new ElementChecker(key, Compare.LESS_THAN, endValue);
        }

        public void map(NullWritable key, FaunusVertex value, Mapper.Context context) throws IOException, InterruptedException {
            if (this.isVertex) {
                if (!(!value.hasPaths() || this.startChecker.isLegal(value) && this.endChecker.isLegal(value))) {
                    value.clearPaths();
                    HadoopCompatLoader.DEFAULT_COMPAT.incrementContextCounter((TaskInputOutputContext)context, Counters.VERTICES_FILTERED, 1L);
                }
            } else {
                long counter = 0L;
                for (Edge e : value.getEdges(Direction.BOTH, new String[0])) {
                    StandardFaunusEdge edge = (StandardFaunusEdge)e;
                    if (!edge.hasPaths() || this.startChecker.isLegal(edge) && this.endChecker.isLegal(edge)) continue;
                    edge.clearPaths();
                    ++counter;
                }
                HadoopCompatLoader.DEFAULT_COMPAT.incrementContextCounter((TaskInputOutputContext)context, Counters.EDGES_FILTERED, counter);
            }
            context.write((Object)NullWritable.get(), (Object)value);
        }
    }

    public static enum Counters {
        VERTICES_FILTERED,
        EDGES_FILTERED;

    }
}

