/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.accumulo;

import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.vertexium.VertexiumException;
import org.vertexium.property.StreamingPropertyValue;
import org.vertexium.property.StreamingPropertyValueRef;

class StreamingPropertyValueHdfs
extends StreamingPropertyValue {
    private final FileSystem fs;
    private final Path path;

    public StreamingPropertyValueHdfs(FileSystem fs, Path path, StreamingPropertyValueRef streamingPropertyValueRef) {
        super(null, streamingPropertyValueRef.getValueType());
        this.store(streamingPropertyValueRef.isStore());
        this.searchIndex(streamingPropertyValueRef.isSearchIndex());
        this.fs = fs;
        this.path = path;
    }

    public long getLength() {
        try {
            return this.fs.getFileStatus(this.path).getLen();
        }
        catch (IOException ex) {
            throw new VertexiumException("Could not get length of: " + this.path, (Throwable)ex);
        }
    }

    public InputStream getInputStream() {
        try {
            return this.fs.open(this.path);
        }
        catch (IOException ex) {
            throw new VertexiumException("Could not open: " + this.path, (Throwable)ex);
        }
    }
}

