/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.inmemory;

import java.io.Serializable;
import java.util.Arrays;
import org.vertexium.Authorizations;
import org.vertexium.VertexiumException;
import org.vertexium.Visibility;
import org.vertexium.inmemory.security.ColumnVisibility;
import org.vertexium.inmemory.security.VisibilityEvaluator;
import org.vertexium.inmemory.security.VisibilityParseException;
import org.vertexium.util.ArrayUtils;
import org.vertexium.util.Preconditions;

public class InMemoryAuthorizations
implements Authorizations,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String[] authorizations;

    public InMemoryAuthorizations(String ... authorizations) {
        this.authorizations = authorizations;
    }

    public String[] getAuthorizations() {
        return this.authorizations;
    }

    public boolean equals(Authorizations authorizations) {
        return ArrayUtils.intersectsAll((Object[])this.getAuthorizations(), (Object[])authorizations.getAuthorizations());
    }

    public String toString() {
        return Arrays.toString(this.authorizations);
    }

    public boolean canRead(Visibility visibility) {
        Preconditions.checkNotNull((Object)visibility, (Object)"visibility is required");
        if (visibility.getVisibilityString().length() == 0) {
            return true;
        }
        VisibilityEvaluator visibilityEvaluator = new VisibilityEvaluator(new org.vertexium.inmemory.security.Authorizations(this.getAuthorizations()));
        ColumnVisibility columnVisibility = new ColumnVisibility(visibility.getVisibilityString());
        try {
            return visibilityEvaluator.evaluate(columnVisibility);
        }
        catch (VisibilityParseException e) {
            throw new VertexiumException("could not evaluate visibility " + visibility.getVisibilityString(), (Throwable)e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InMemoryAuthorizations that = (InMemoryAuthorizations)o;
        return ArrayUtils.intersectsAll((Object[])this.getAuthorizations(), (Object[])that.getAuthorizations());
    }

    public int hashCode() {
        return Arrays.hashCode(this.authorizations);
    }
}

