/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.tabletserver.thrift;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.accumulo.core.data.thrift.IterInfo;
import org.apache.accumulo.core.data.thrift.TKeyExtent;
import org.apache.accumulo.core.tabletserver.thrift.CompactionReason;
import org.apache.accumulo.core.tabletserver.thrift.CompactionType;
import org.apache.thrift.EncodingUtils;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.meta_data.EnumMetaData;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.ListMetaData;
import org.apache.thrift.meta_data.MapMetaData;
import org.apache.thrift.meta_data.StructMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TMap;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

public class ActiveCompaction
implements TBase<ActiveCompaction, _Fields>,
Serializable,
Cloneable {
    private static final TStruct STRUCT_DESC = new TStruct("ActiveCompaction");
    private static final TField EXTENT_FIELD_DESC = new TField("extent", 12, 1);
    private static final TField AGE_FIELD_DESC = new TField("age", 10, 2);
    private static final TField INPUT_FILES_FIELD_DESC = new TField("inputFiles", 15, 3);
    private static final TField OUTPUT_FILE_FIELD_DESC = new TField("outputFile", 11, 4);
    private static final TField TYPE_FIELD_DESC = new TField("type", 8, 5);
    private static final TField REASON_FIELD_DESC = new TField("reason", 8, 6);
    private static final TField LOCALITY_GROUP_FIELD_DESC = new TField("localityGroup", 11, 7);
    private static final TField ENTRIES_READ_FIELD_DESC = new TField("entriesRead", 10, 8);
    private static final TField ENTRIES_WRITTEN_FIELD_DESC = new TField("entriesWritten", 10, 9);
    private static final TField SSI_LIST_FIELD_DESC = new TField("ssiList", 15, 10);
    private static final TField SSIO_FIELD_DESC = new TField("ssio", 13, 11);
    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    public TKeyExtent extent;
    public long age;
    public List<String> inputFiles;
    public String outputFile;
    public CompactionType type;
    public CompactionReason reason;
    public String localityGroup;
    public long entriesRead;
    public long entriesWritten;
    public List<IterInfo> ssiList;
    public Map<String, Map<String, String>> ssio;
    private static final int __AGE_ISSET_ID = 0;
    private static final int __ENTRIESREAD_ISSET_ID = 1;
    private static final int __ENTRIESWRITTEN_ISSET_ID = 2;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public ActiveCompaction() {
    }

    public ActiveCompaction(TKeyExtent extent, long age, List<String> inputFiles, String outputFile, CompactionType type, CompactionReason reason, String localityGroup, long entriesRead, long entriesWritten, List<IterInfo> ssiList, Map<String, Map<String, String>> ssio) {
        this();
        this.extent = extent;
        this.age = age;
        this.setAgeIsSet(true);
        this.inputFiles = inputFiles;
        this.outputFile = outputFile;
        this.type = type;
        this.reason = reason;
        this.localityGroup = localityGroup;
        this.entriesRead = entriesRead;
        this.setEntriesReadIsSet(true);
        this.entriesWritten = entriesWritten;
        this.setEntriesWrittenIsSet(true);
        this.ssiList = ssiList;
        this.ssio = ssio;
    }

    public ActiveCompaction(ActiveCompaction other) {
        this.__isset_bitfield = other.__isset_bitfield;
        if (other.isSetExtent()) {
            this.extent = new TKeyExtent(other.extent);
        }
        this.age = other.age;
        if (other.isSetInputFiles()) {
            ArrayList<String> __this__inputFiles = new ArrayList<String>();
            for (String string : other.inputFiles) {
                __this__inputFiles.add(string);
            }
            this.inputFiles = __this__inputFiles;
        }
        if (other.isSetOutputFile()) {
            this.outputFile = other.outputFile;
        }
        if (other.isSetType()) {
            this.type = other.type;
        }
        if (other.isSetReason()) {
            this.reason = other.reason;
        }
        if (other.isSetLocalityGroup()) {
            this.localityGroup = other.localityGroup;
        }
        this.entriesRead = other.entriesRead;
        this.entriesWritten = other.entriesWritten;
        if (other.isSetSsiList()) {
            ArrayList<IterInfo> __this__ssiList = new ArrayList<IterInfo>();
            for (IterInfo iterInfo : other.ssiList) {
                __this__ssiList.add(new IterInfo(iterInfo));
            }
            this.ssiList = __this__ssiList;
        }
        if (other.isSetSsio()) {
            HashMap<String, Map<String, String>> __this__ssio = new HashMap<String, Map<String, String>>();
            for (Map.Entry entry : other.ssio.entrySet()) {
                String other_element_key = (String)entry.getKey();
                Map other_element_value = (Map)entry.getValue();
                String __this__ssio_copy_key = other_element_key;
                HashMap<String, String> __this__ssio_copy_value = new HashMap<String, String>();
                for (Map.Entry other_element_value_element : other_element_value.entrySet()) {
                    String other_element_value_element_key = (String)other_element_value_element.getKey();
                    String other_element_value_element_value = (String)other_element_value_element.getValue();
                    String __this__ssio_copy_value_copy_key = other_element_value_element_key;
                    String __this__ssio_copy_value_copy_value = other_element_value_element_value;
                    __this__ssio_copy_value.put(__this__ssio_copy_value_copy_key, __this__ssio_copy_value_copy_value);
                }
                __this__ssio.put(__this__ssio_copy_key, __this__ssio_copy_value);
            }
            this.ssio = __this__ssio;
        }
    }

    public ActiveCompaction deepCopy() {
        return new ActiveCompaction(this);
    }

    public void clear() {
        this.extent = null;
        this.setAgeIsSet(false);
        this.age = 0L;
        this.inputFiles = null;
        this.outputFile = null;
        this.type = null;
        this.reason = null;
        this.localityGroup = null;
        this.setEntriesReadIsSet(false);
        this.entriesRead = 0L;
        this.setEntriesWrittenIsSet(false);
        this.entriesWritten = 0L;
        this.ssiList = null;
        this.ssio = null;
    }

    public TKeyExtent getExtent() {
        return this.extent;
    }

    public ActiveCompaction setExtent(TKeyExtent extent) {
        this.extent = extent;
        return this;
    }

    public void unsetExtent() {
        this.extent = null;
    }

    public boolean isSetExtent() {
        return this.extent != null;
    }

    public void setExtentIsSet(boolean value) {
        if (!value) {
            this.extent = null;
        }
    }

    public long getAge() {
        return this.age;
    }

    public ActiveCompaction setAge(long age) {
        this.age = age;
        this.setAgeIsSet(true);
        return this;
    }

    public void unsetAge() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)0);
    }

    public boolean isSetAge() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)0);
    }

    public void setAgeIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)0, (boolean)value);
    }

    public int getInputFilesSize() {
        return this.inputFiles == null ? 0 : this.inputFiles.size();
    }

    public Iterator<String> getInputFilesIterator() {
        return this.inputFiles == null ? null : this.inputFiles.iterator();
    }

    public void addToInputFiles(String elem) {
        if (this.inputFiles == null) {
            this.inputFiles = new ArrayList<String>();
        }
        this.inputFiles.add(elem);
    }

    public List<String> getInputFiles() {
        return this.inputFiles;
    }

    public ActiveCompaction setInputFiles(List<String> inputFiles) {
        this.inputFiles = inputFiles;
        return this;
    }

    public void unsetInputFiles() {
        this.inputFiles = null;
    }

    public boolean isSetInputFiles() {
        return this.inputFiles != null;
    }

    public void setInputFilesIsSet(boolean value) {
        if (!value) {
            this.inputFiles = null;
        }
    }

    public String getOutputFile() {
        return this.outputFile;
    }

    public ActiveCompaction setOutputFile(String outputFile) {
        this.outputFile = outputFile;
        return this;
    }

    public void unsetOutputFile() {
        this.outputFile = null;
    }

    public boolean isSetOutputFile() {
        return this.outputFile != null;
    }

    public void setOutputFileIsSet(boolean value) {
        if (!value) {
            this.outputFile = null;
        }
    }

    public CompactionType getType() {
        return this.type;
    }

    public ActiveCompaction setType(CompactionType type) {
        this.type = type;
        return this;
    }

    public void unsetType() {
        this.type = null;
    }

    public boolean isSetType() {
        return this.type != null;
    }

    public void setTypeIsSet(boolean value) {
        if (!value) {
            this.type = null;
        }
    }

    public CompactionReason getReason() {
        return this.reason;
    }

    public ActiveCompaction setReason(CompactionReason reason) {
        this.reason = reason;
        return this;
    }

    public void unsetReason() {
        this.reason = null;
    }

    public boolean isSetReason() {
        return this.reason != null;
    }

    public void setReasonIsSet(boolean value) {
        if (!value) {
            this.reason = null;
        }
    }

    public String getLocalityGroup() {
        return this.localityGroup;
    }

    public ActiveCompaction setLocalityGroup(String localityGroup) {
        this.localityGroup = localityGroup;
        return this;
    }

    public void unsetLocalityGroup() {
        this.localityGroup = null;
    }

    public boolean isSetLocalityGroup() {
        return this.localityGroup != null;
    }

    public void setLocalityGroupIsSet(boolean value) {
        if (!value) {
            this.localityGroup = null;
        }
    }

    public long getEntriesRead() {
        return this.entriesRead;
    }

    public ActiveCompaction setEntriesRead(long entriesRead) {
        this.entriesRead = entriesRead;
        this.setEntriesReadIsSet(true);
        return this;
    }

    public void unsetEntriesRead() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)1);
    }

    public boolean isSetEntriesRead() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)1);
    }

    public void setEntriesReadIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)1, (boolean)value);
    }

    public long getEntriesWritten() {
        return this.entriesWritten;
    }

    public ActiveCompaction setEntriesWritten(long entriesWritten) {
        this.entriesWritten = entriesWritten;
        this.setEntriesWrittenIsSet(true);
        return this;
    }

    public void unsetEntriesWritten() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)2);
    }

    public boolean isSetEntriesWritten() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)2);
    }

    public void setEntriesWrittenIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)2, (boolean)value);
    }

    public int getSsiListSize() {
        return this.ssiList == null ? 0 : this.ssiList.size();
    }

    public Iterator<IterInfo> getSsiListIterator() {
        return this.ssiList == null ? null : this.ssiList.iterator();
    }

    public void addToSsiList(IterInfo elem) {
        if (this.ssiList == null) {
            this.ssiList = new ArrayList<IterInfo>();
        }
        this.ssiList.add(elem);
    }

    public List<IterInfo> getSsiList() {
        return this.ssiList;
    }

    public ActiveCompaction setSsiList(List<IterInfo> ssiList) {
        this.ssiList = ssiList;
        return this;
    }

    public void unsetSsiList() {
        this.ssiList = null;
    }

    public boolean isSetSsiList() {
        return this.ssiList != null;
    }

    public void setSsiListIsSet(boolean value) {
        if (!value) {
            this.ssiList = null;
        }
    }

    public int getSsioSize() {
        return this.ssio == null ? 0 : this.ssio.size();
    }

    public void putToSsio(String key, Map<String, String> val) {
        if (this.ssio == null) {
            this.ssio = new HashMap<String, Map<String, String>>();
        }
        this.ssio.put(key, val);
    }

    public Map<String, Map<String, String>> getSsio() {
        return this.ssio;
    }

    public ActiveCompaction setSsio(Map<String, Map<String, String>> ssio) {
        this.ssio = ssio;
        return this;
    }

    public void unsetSsio() {
        this.ssio = null;
    }

    public boolean isSetSsio() {
        return this.ssio != null;
    }

    public void setSsioIsSet(boolean value) {
        if (!value) {
            this.ssio = null;
        }
    }

    public void setFieldValue(_Fields field, Object value) {
        switch (field) {
            case EXTENT: {
                if (value == null) {
                    this.unsetExtent();
                    break;
                }
                this.setExtent((TKeyExtent)value);
                break;
            }
            case AGE: {
                if (value == null) {
                    this.unsetAge();
                    break;
                }
                this.setAge((Long)value);
                break;
            }
            case INPUT_FILES: {
                if (value == null) {
                    this.unsetInputFiles();
                    break;
                }
                this.setInputFiles((List)value);
                break;
            }
            case OUTPUT_FILE: {
                if (value == null) {
                    this.unsetOutputFile();
                    break;
                }
                this.setOutputFile((String)value);
                break;
            }
            case TYPE: {
                if (value == null) {
                    this.unsetType();
                    break;
                }
                this.setType((CompactionType)((Object)value));
                break;
            }
            case REASON: {
                if (value == null) {
                    this.unsetReason();
                    break;
                }
                this.setReason((CompactionReason)((Object)value));
                break;
            }
            case LOCALITY_GROUP: {
                if (value == null) {
                    this.unsetLocalityGroup();
                    break;
                }
                this.setLocalityGroup((String)value);
                break;
            }
            case ENTRIES_READ: {
                if (value == null) {
                    this.unsetEntriesRead();
                    break;
                }
                this.setEntriesRead((Long)value);
                break;
            }
            case ENTRIES_WRITTEN: {
                if (value == null) {
                    this.unsetEntriesWritten();
                    break;
                }
                this.setEntriesWritten((Long)value);
                break;
            }
            case SSI_LIST: {
                if (value == null) {
                    this.unsetSsiList();
                    break;
                }
                this.setSsiList((List)value);
                break;
            }
            case SSIO: {
                if (value == null) {
                    this.unsetSsio();
                    break;
                }
                this.setSsio((Map)value);
            }
        }
    }

    public Object getFieldValue(_Fields field) {
        switch (field) {
            case EXTENT: {
                return this.getExtent();
            }
            case AGE: {
                return this.getAge();
            }
            case INPUT_FILES: {
                return this.getInputFiles();
            }
            case OUTPUT_FILE: {
                return this.getOutputFile();
            }
            case TYPE: {
                return this.getType();
            }
            case REASON: {
                return this.getReason();
            }
            case LOCALITY_GROUP: {
                return this.getLocalityGroup();
            }
            case ENTRIES_READ: {
                return this.getEntriesRead();
            }
            case ENTRIES_WRITTEN: {
                return this.getEntriesWritten();
            }
            case SSI_LIST: {
                return this.getSsiList();
            }
            case SSIO: {
                return this.getSsio();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case EXTENT: {
                return this.isSetExtent();
            }
            case AGE: {
                return this.isSetAge();
            }
            case INPUT_FILES: {
                return this.isSetInputFiles();
            }
            case OUTPUT_FILE: {
                return this.isSetOutputFile();
            }
            case TYPE: {
                return this.isSetType();
            }
            case REASON: {
                return this.isSetReason();
            }
            case LOCALITY_GROUP: {
                return this.isSetLocalityGroup();
            }
            case ENTRIES_READ: {
                return this.isSetEntriesRead();
            }
            case ENTRIES_WRITTEN: {
                return this.isSetEntriesWritten();
            }
            case SSI_LIST: {
                return this.isSetSsiList();
            }
            case SSIO: {
                return this.isSetSsio();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof ActiveCompaction) {
            return this.equals((ActiveCompaction)that);
        }
        return false;
    }

    public boolean equals(ActiveCompaction that) {
        if (that == null) {
            return false;
        }
        boolean this_present_extent = this.isSetExtent();
        boolean that_present_extent = that.isSetExtent();
        if (this_present_extent || that_present_extent) {
            if (!this_present_extent || !that_present_extent) {
                return false;
            }
            if (!this.extent.equals(that.extent)) {
                return false;
            }
        }
        boolean this_present_age = true;
        boolean that_present_age = true;
        if (this_present_age || that_present_age) {
            if (!this_present_age || !that_present_age) {
                return false;
            }
            if (this.age != that.age) {
                return false;
            }
        }
        boolean this_present_inputFiles = this.isSetInputFiles();
        boolean that_present_inputFiles = that.isSetInputFiles();
        if (this_present_inputFiles || that_present_inputFiles) {
            if (!this_present_inputFiles || !that_present_inputFiles) {
                return false;
            }
            if (!this.inputFiles.equals(that.inputFiles)) {
                return false;
            }
        }
        boolean this_present_outputFile = this.isSetOutputFile();
        boolean that_present_outputFile = that.isSetOutputFile();
        if (this_present_outputFile || that_present_outputFile) {
            if (!this_present_outputFile || !that_present_outputFile) {
                return false;
            }
            if (!this.outputFile.equals(that.outputFile)) {
                return false;
            }
        }
        boolean this_present_type = this.isSetType();
        boolean that_present_type = that.isSetType();
        if (this_present_type || that_present_type) {
            if (!this_present_type || !that_present_type) {
                return false;
            }
            if (!this.type.equals((Object)that.type)) {
                return false;
            }
        }
        boolean this_present_reason = this.isSetReason();
        boolean that_present_reason = that.isSetReason();
        if (this_present_reason || that_present_reason) {
            if (!this_present_reason || !that_present_reason) {
                return false;
            }
            if (!this.reason.equals((Object)that.reason)) {
                return false;
            }
        }
        boolean this_present_localityGroup = this.isSetLocalityGroup();
        boolean that_present_localityGroup = that.isSetLocalityGroup();
        if (this_present_localityGroup || that_present_localityGroup) {
            if (!this_present_localityGroup || !that_present_localityGroup) {
                return false;
            }
            if (!this.localityGroup.equals(that.localityGroup)) {
                return false;
            }
        }
        boolean this_present_entriesRead = true;
        boolean that_present_entriesRead = true;
        if (this_present_entriesRead || that_present_entriesRead) {
            if (!this_present_entriesRead || !that_present_entriesRead) {
                return false;
            }
            if (this.entriesRead != that.entriesRead) {
                return false;
            }
        }
        boolean this_present_entriesWritten = true;
        boolean that_present_entriesWritten = true;
        if (this_present_entriesWritten || that_present_entriesWritten) {
            if (!this_present_entriesWritten || !that_present_entriesWritten) {
                return false;
            }
            if (this.entriesWritten != that.entriesWritten) {
                return false;
            }
        }
        boolean this_present_ssiList = this.isSetSsiList();
        boolean that_present_ssiList = that.isSetSsiList();
        if (this_present_ssiList || that_present_ssiList) {
            if (!this_present_ssiList || !that_present_ssiList) {
                return false;
            }
            if (!this.ssiList.equals(that.ssiList)) {
                return false;
            }
        }
        boolean this_present_ssio = this.isSetSsio();
        boolean that_present_ssio = that.isSetSsio();
        if (this_present_ssio || that_present_ssio) {
            if (!this_present_ssio || !that_present_ssio) {
                return false;
            }
            if (!this.ssio.equals(that.ssio)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        return 0;
    }

    public int compareTo(ActiveCompaction other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        ActiveCompaction typedOther = other;
        lastComparison = Boolean.valueOf(this.isSetExtent()).compareTo(typedOther.isSetExtent());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetExtent() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.extent), (Comparable)((Object)typedOther.extent))) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetAge()).compareTo(typedOther.isSetAge());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetAge() && (lastComparison = TBaseHelper.compareTo((long)this.age, (long)typedOther.age)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetInputFiles()).compareTo(typedOther.isSetInputFiles());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetInputFiles() && (lastComparison = TBaseHelper.compareTo(this.inputFiles, typedOther.inputFiles)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetOutputFile()).compareTo(typedOther.isSetOutputFile());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetOutputFile() && (lastComparison = TBaseHelper.compareTo((String)this.outputFile, (String)typedOther.outputFile)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetType()).compareTo(typedOther.isSetType());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetType() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.type), (Comparable)((Object)typedOther.type))) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetReason()).compareTo(typedOther.isSetReason());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetReason() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.reason), (Comparable)((Object)typedOther.reason))) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetLocalityGroup()).compareTo(typedOther.isSetLocalityGroup());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetLocalityGroup() && (lastComparison = TBaseHelper.compareTo((String)this.localityGroup, (String)typedOther.localityGroup)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetEntriesRead()).compareTo(typedOther.isSetEntriesRead());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetEntriesRead() && (lastComparison = TBaseHelper.compareTo((long)this.entriesRead, (long)typedOther.entriesRead)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetEntriesWritten()).compareTo(typedOther.isSetEntriesWritten());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetEntriesWritten() && (lastComparison = TBaseHelper.compareTo((long)this.entriesWritten, (long)typedOther.entriesWritten)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetSsiList()).compareTo(typedOther.isSetSsiList());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetSsiList() && (lastComparison = TBaseHelper.compareTo(this.ssiList, typedOther.ssiList)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetSsio()).compareTo(typedOther.isSetSsio());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetSsio() && (lastComparison = TBaseHelper.compareTo(this.ssio, typedOther.ssio)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public void read(TProtocol iprot) throws TException {
        schemes.get(iprot.getScheme()).getScheme().read(iprot, (TBase)this);
    }

    public void write(TProtocol oprot) throws TException {
        schemes.get(oprot.getScheme()).getScheme().write(oprot, (TBase)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ActiveCompaction(");
        boolean first = true;
        sb.append("extent:");
        if (this.extent == null) {
            sb.append("null");
        } else {
            sb.append(this.extent);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("age:");
        sb.append(this.age);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("inputFiles:");
        if (this.inputFiles == null) {
            sb.append("null");
        } else {
            sb.append(this.inputFiles);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("outputFile:");
        if (this.outputFile == null) {
            sb.append("null");
        } else {
            sb.append(this.outputFile);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("type:");
        if (this.type == null) {
            sb.append("null");
        } else {
            sb.append((Object)this.type);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("reason:");
        if (this.reason == null) {
            sb.append("null");
        } else {
            sb.append((Object)this.reason);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("localityGroup:");
        if (this.localityGroup == null) {
            sb.append("null");
        } else {
            sb.append(this.localityGroup);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("entriesRead:");
        sb.append(this.entriesRead);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("entriesWritten:");
        sb.append(this.entriesWritten);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("ssiList:");
        if (this.ssiList == null) {
            sb.append("null");
        } else {
            sb.append(this.ssiList);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("ssio:");
        if (this.ssio == null) {
            sb.append("null");
        } else {
            sb.append(this.ssio);
        }
        first = false;
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (this.extent != null) {
            this.extent.validate();
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.__isset_bitfield = 0;
            this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    static {
        schemes.put(StandardScheme.class, new ActiveCompactionStandardSchemeFactory());
        schemes.put(TupleScheme.class, new ActiveCompactionTupleSchemeFactory());
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.EXTENT, new FieldMetaData("extent", 3, (FieldValueMetaData)new StructMetaData(12, TKeyExtent.class)));
        tmpMap.put(_Fields.AGE, new FieldMetaData("age", 3, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.INPUT_FILES, new FieldMetaData("inputFiles", 3, (FieldValueMetaData)new ListMetaData(15, new FieldValueMetaData(11))));
        tmpMap.put(_Fields.OUTPUT_FILE, new FieldMetaData("outputFile", 3, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.TYPE, new FieldMetaData("type", 3, (FieldValueMetaData)new EnumMetaData(16, CompactionType.class)));
        tmpMap.put(_Fields.REASON, new FieldMetaData("reason", 3, (FieldValueMetaData)new EnumMetaData(16, CompactionReason.class)));
        tmpMap.put(_Fields.LOCALITY_GROUP, new FieldMetaData("localityGroup", 3, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.ENTRIES_READ, new FieldMetaData("entriesRead", 3, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.ENTRIES_WRITTEN, new FieldMetaData("entriesWritten", 3, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.SSI_LIST, new FieldMetaData("ssiList", 3, (FieldValueMetaData)new ListMetaData(15, (FieldValueMetaData)new StructMetaData(12, IterInfo.class))));
        tmpMap.put(_Fields.SSIO, new FieldMetaData("ssio", 3, (FieldValueMetaData)new MapMetaData(13, new FieldValueMetaData(11), (FieldValueMetaData)new MapMetaData(13, new FieldValueMetaData(11), new FieldValueMetaData(11)))));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(ActiveCompaction.class, metaDataMap);
    }

    private static class ActiveCompactionTupleScheme
    extends TupleScheme<ActiveCompaction> {
        private ActiveCompactionTupleScheme() {
        }

        public void write(TProtocol prot, ActiveCompaction struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            BitSet optionals = new BitSet();
            if (struct.isSetExtent()) {
                optionals.set(0);
            }
            if (struct.isSetAge()) {
                optionals.set(1);
            }
            if (struct.isSetInputFiles()) {
                optionals.set(2);
            }
            if (struct.isSetOutputFile()) {
                optionals.set(3);
            }
            if (struct.isSetType()) {
                optionals.set(4);
            }
            if (struct.isSetReason()) {
                optionals.set(5);
            }
            if (struct.isSetLocalityGroup()) {
                optionals.set(6);
            }
            if (struct.isSetEntriesRead()) {
                optionals.set(7);
            }
            if (struct.isSetEntriesWritten()) {
                optionals.set(8);
            }
            if (struct.isSetSsiList()) {
                optionals.set(9);
            }
            if (struct.isSetSsio()) {
                optionals.set(10);
            }
            oprot.writeBitSet(optionals, 11);
            if (struct.isSetExtent()) {
                struct.extent.write((TProtocol)oprot);
            }
            if (struct.isSetAge()) {
                oprot.writeI64(struct.age);
            }
            if (struct.isSetInputFiles()) {
                oprot.writeI32(struct.inputFiles.size());
                for (String string : struct.inputFiles) {
                    oprot.writeString(string);
                }
            }
            if (struct.isSetOutputFile()) {
                oprot.writeString(struct.outputFile);
            }
            if (struct.isSetType()) {
                oprot.writeI32(struct.type.getValue());
            }
            if (struct.isSetReason()) {
                oprot.writeI32(struct.reason.getValue());
            }
            if (struct.isSetLocalityGroup()) {
                oprot.writeString(struct.localityGroup);
            }
            if (struct.isSetEntriesRead()) {
                oprot.writeI64(struct.entriesRead);
            }
            if (struct.isSetEntriesWritten()) {
                oprot.writeI64(struct.entriesWritten);
            }
            if (struct.isSetSsiList()) {
                oprot.writeI32(struct.ssiList.size());
                for (IterInfo iterInfo : struct.ssiList) {
                    iterInfo.write((TProtocol)oprot);
                }
            }
            if (struct.isSetSsio()) {
                oprot.writeI32(struct.ssio.size());
                for (Map.Entry entry : struct.ssio.entrySet()) {
                    oprot.writeString((String)entry.getKey());
                    oprot.writeI32(((Map)entry.getValue()).size());
                    for (Map.Entry _iter73 : ((Map)entry.getValue()).entrySet()) {
                        oprot.writeString((String)_iter73.getKey());
                        oprot.writeString((String)_iter73.getValue());
                    }
                }
            }
        }

        public void read(TProtocol prot, ActiveCompaction struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            BitSet incoming = iprot.readBitSet(11);
            if (incoming.get(0)) {
                struct.extent = new TKeyExtent();
                struct.extent.read((TProtocol)iprot);
                struct.setExtentIsSet(true);
            }
            if (incoming.get(1)) {
                struct.age = iprot.readI64();
                struct.setAgeIsSet(true);
            }
            if (incoming.get(2)) {
                TList _list74 = new TList(11, iprot.readI32());
                struct.inputFiles = new ArrayList<String>(_list74.size);
                for (int _i75 = 0; _i75 < _list74.size; ++_i75) {
                    String _elem76 = iprot.readString();
                    struct.inputFiles.add(_elem76);
                }
                struct.setInputFilesIsSet(true);
            }
            if (incoming.get(3)) {
                struct.outputFile = iprot.readString();
                struct.setOutputFileIsSet(true);
            }
            if (incoming.get(4)) {
                struct.type = CompactionType.findByValue(iprot.readI32());
                struct.setTypeIsSet(true);
            }
            if (incoming.get(5)) {
                struct.reason = CompactionReason.findByValue(iprot.readI32());
                struct.setReasonIsSet(true);
            }
            if (incoming.get(6)) {
                struct.localityGroup = iprot.readString();
                struct.setLocalityGroupIsSet(true);
            }
            if (incoming.get(7)) {
                struct.entriesRead = iprot.readI64();
                struct.setEntriesReadIsSet(true);
            }
            if (incoming.get(8)) {
                struct.entriesWritten = iprot.readI64();
                struct.setEntriesWrittenIsSet(true);
            }
            if (incoming.get(9)) {
                TList _list77 = new TList(12, iprot.readI32());
                struct.ssiList = new ArrayList<IterInfo>(_list77.size);
                for (int _i78 = 0; _i78 < _list77.size; ++_i78) {
                    IterInfo _elem79 = new IterInfo();
                    _elem79.read((TProtocol)iprot);
                    struct.ssiList.add(_elem79);
                }
                struct.setSsiListIsSet(true);
            }
            if (incoming.get(10)) {
                TMap _map80 = new TMap(11, 13, iprot.readI32());
                struct.ssio = new HashMap<String, Map<String, String>>(2 * _map80.size);
                for (int _i81 = 0; _i81 < _map80.size; ++_i81) {
                    String _key82 = iprot.readString();
                    TMap _map84 = new TMap(11, 11, iprot.readI32());
                    HashMap<String, String> _val83 = new HashMap<String, String>(2 * _map84.size);
                    for (int _i85 = 0; _i85 < _map84.size; ++_i85) {
                        String _key86 = iprot.readString();
                        String _val87 = iprot.readString();
                        _val83.put(_key86, _val87);
                    }
                    struct.ssio.put(_key82, _val83);
                }
                struct.setSsioIsSet(true);
            }
        }
    }

    private static class ActiveCompactionTupleSchemeFactory
    implements SchemeFactory {
        private ActiveCompactionTupleSchemeFactory() {
        }

        public ActiveCompactionTupleScheme getScheme() {
            return new ActiveCompactionTupleScheme();
        }
    }

    private static class ActiveCompactionStandardScheme
    extends StandardScheme<ActiveCompaction> {
        private ActiveCompactionStandardScheme() {
        }

        public void read(TProtocol iprot, ActiveCompaction struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 12) {
                            struct.extent = new TKeyExtent();
                            struct.extent.read(iprot);
                            struct.setExtentIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 10) {
                            struct.age = iprot.readI64();
                            struct.setAgeIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 3: {
                        if (schemeField.type == 15) {
                            TList _list52 = iprot.readListBegin();
                            struct.inputFiles = new ArrayList<String>(_list52.size);
                            for (int _i53 = 0; _i53 < _list52.size; ++_i53) {
                                String _elem54 = iprot.readString();
                                struct.inputFiles.add(_elem54);
                            }
                            iprot.readListEnd();
                            struct.setInputFilesIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 4: {
                        if (schemeField.type == 11) {
                            struct.outputFile = iprot.readString();
                            struct.setOutputFileIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 5: {
                        if (schemeField.type == 8) {
                            struct.type = CompactionType.findByValue(iprot.readI32());
                            struct.setTypeIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 6: {
                        if (schemeField.type == 8) {
                            struct.reason = CompactionReason.findByValue(iprot.readI32());
                            struct.setReasonIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 7: {
                        if (schemeField.type == 11) {
                            struct.localityGroup = iprot.readString();
                            struct.setLocalityGroupIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 8: {
                        if (schemeField.type == 10) {
                            struct.entriesRead = iprot.readI64();
                            struct.setEntriesReadIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 9: {
                        if (schemeField.type == 10) {
                            struct.entriesWritten = iprot.readI64();
                            struct.setEntriesWrittenIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 10: {
                        if (schemeField.type == 15) {
                            TList _list55 = iprot.readListBegin();
                            struct.ssiList = new ArrayList<IterInfo>(_list55.size);
                            for (int _i56 = 0; _i56 < _list55.size; ++_i56) {
                                IterInfo _elem57 = new IterInfo();
                                _elem57.read(iprot);
                                struct.ssiList.add(_elem57);
                            }
                            iprot.readListEnd();
                            struct.setSsiListIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 11: {
                        if (schemeField.type == 13) {
                            TMap _map58 = iprot.readMapBegin();
                            struct.ssio = new HashMap<String, Map<String, String>>(2 * _map58.size);
                            for (int _i59 = 0; _i59 < _map58.size; ++_i59) {
                                String _key60 = iprot.readString();
                                TMap _map62 = iprot.readMapBegin();
                                HashMap<String, String> _val61 = new HashMap<String, String>(2 * _map62.size);
                                for (int _i63 = 0; _i63 < _map62.size; ++_i63) {
                                    String _key64 = iprot.readString();
                                    String _val65 = iprot.readString();
                                    _val61.put(_key64, _val65);
                                }
                                iprot.readMapEnd();
                                struct.ssio.put(_key60, _val61);
                            }
                            iprot.readMapEnd();
                            struct.setSsioIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            struct.validate();
        }

        public void write(TProtocol oprot, ActiveCompaction struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (struct.extent != null) {
                oprot.writeFieldBegin(EXTENT_FIELD_DESC);
                struct.extent.write(oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldBegin(AGE_FIELD_DESC);
            oprot.writeI64(struct.age);
            oprot.writeFieldEnd();
            if (struct.inputFiles != null) {
                oprot.writeFieldBegin(INPUT_FILES_FIELD_DESC);
                oprot.writeListBegin(new TList(11, struct.inputFiles.size()));
                for (String string : struct.inputFiles) {
                    oprot.writeString(string);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            if (struct.outputFile != null) {
                oprot.writeFieldBegin(OUTPUT_FILE_FIELD_DESC);
                oprot.writeString(struct.outputFile);
                oprot.writeFieldEnd();
            }
            if (struct.type != null) {
                oprot.writeFieldBegin(TYPE_FIELD_DESC);
                oprot.writeI32(struct.type.getValue());
                oprot.writeFieldEnd();
            }
            if (struct.reason != null) {
                oprot.writeFieldBegin(REASON_FIELD_DESC);
                oprot.writeI32(struct.reason.getValue());
                oprot.writeFieldEnd();
            }
            if (struct.localityGroup != null) {
                oprot.writeFieldBegin(LOCALITY_GROUP_FIELD_DESC);
                oprot.writeString(struct.localityGroup);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldBegin(ENTRIES_READ_FIELD_DESC);
            oprot.writeI64(struct.entriesRead);
            oprot.writeFieldEnd();
            oprot.writeFieldBegin(ENTRIES_WRITTEN_FIELD_DESC);
            oprot.writeI64(struct.entriesWritten);
            oprot.writeFieldEnd();
            if (struct.ssiList != null) {
                oprot.writeFieldBegin(SSI_LIST_FIELD_DESC);
                oprot.writeListBegin(new TList(12, struct.ssiList.size()));
                for (IterInfo iterInfo : struct.ssiList) {
                    iterInfo.write(oprot);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            if (struct.ssio != null) {
                oprot.writeFieldBegin(SSIO_FIELD_DESC);
                oprot.writeMapBegin(new TMap(11, 13, struct.ssio.size()));
                for (Map.Entry entry : struct.ssio.entrySet()) {
                    oprot.writeString((String)entry.getKey());
                    oprot.writeMapBegin(new TMap(11, 11, ((Map)entry.getValue()).size()));
                    for (Map.Entry _iter69 : ((Map)entry.getValue()).entrySet()) {
                        oprot.writeString((String)_iter69.getKey());
                        oprot.writeString((String)_iter69.getValue());
                    }
                    oprot.writeMapEnd();
                }
                oprot.writeMapEnd();
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class ActiveCompactionStandardSchemeFactory
    implements SchemeFactory {
        private ActiveCompactionStandardSchemeFactory() {
        }

        public ActiveCompactionStandardScheme getScheme() {
            return new ActiveCompactionStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        EXTENT(1, "extent"),
        AGE(2, "age"),
        INPUT_FILES(3, "inputFiles"),
        OUTPUT_FILE(4, "outputFile"),
        TYPE(5, "type"),
        REASON(6, "reason"),
        LOCALITY_GROUP(7, "localityGroup"),
        ENTRIES_READ(8, "entriesRead"),
        ENTRIES_WRITTEN(9, "entriesWritten"),
        SSI_LIST(10, "ssiList"),
        SSIO(11, "ssio");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return EXTENT;
                }
                case 2: {
                    return AGE;
                }
                case 3: {
                    return INPUT_FILES;
                }
                case 4: {
                    return OUTPUT_FILE;
                }
                case 5: {
                    return TYPE;
                }
                case 6: {
                    return REASON;
                }
                case 7: {
                    return LOCALITY_GROUP;
                }
                case 8: {
                    return ENTRIES_READ;
                }
                case 9: {
                    return ENTRIES_WRITTEN;
                }
                case 10: {
                    return SSI_LIST;
                }
                case 11: {
                    return SSIO;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

