/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.count;

import java.io.IOException;
import org.elasticsearch.Version;
import org.elasticsearch.action.count.CountRequest;
import org.elasticsearch.action.support.broadcast.BroadcastShardOperationRequest;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.shard.ShardId;

class ShardCountRequest
extends BroadcastShardOperationRequest {
    private float minScore;
    private int terminateAfter;
    private BytesReference querySource;
    private String[] types = Strings.EMPTY_ARRAY;
    private long nowInMillis;
    @Nullable
    private String[] filteringAliases;

    ShardCountRequest() {
    }

    ShardCountRequest(ShardId shardId, @Nullable String[] filteringAliases, CountRequest request) {
        super(shardId, request);
        this.minScore = request.minScore();
        this.querySource = request.source();
        this.types = request.types();
        this.filteringAliases = filteringAliases;
        this.nowInMillis = request.nowInMillis;
        this.terminateAfter = request.terminateAfter();
    }

    public float minScore() {
        return this.minScore;
    }

    public BytesReference querySource() {
        return this.querySource;
    }

    public String[] types() {
        return this.types;
    }

    public String[] filteringAliases() {
        return this.filteringAliases;
    }

    public long nowInMillis() {
        return this.nowInMillis;
    }

    public int terminateAfter() {
        return this.terminateAfter;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        int aliasesSize;
        super.readFrom(in);
        this.minScore = in.readFloat();
        this.querySource = in.readBytesReference();
        int typesSize = in.readVInt();
        if (typesSize > 0) {
            this.types = new String[typesSize];
            for (int i = 0; i < typesSize; ++i) {
                this.types[i] = in.readString();
            }
        }
        if ((aliasesSize = in.readVInt()) > 0) {
            this.filteringAliases = new String[aliasesSize];
            for (int i = 0; i < aliasesSize; ++i) {
                this.filteringAliases[i] = in.readString();
            }
        }
        this.nowInMillis = in.readVLong();
        this.terminateAfter = in.getVersion().onOrAfter(Version.V_1_4_0_Beta1) ? in.readVInt() : 0;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeFloat(this.minScore);
        out.writeBytesReference(this.querySource);
        out.writeVInt(this.types.length);
        for (String type : this.types) {
            out.writeString(type);
        }
        if (this.filteringAliases != null) {
            out.writeVInt(this.filteringAliases.length);
            for (String alias : this.filteringAliases) {
                out.writeString(alias);
            }
        } else {
            out.writeVInt(0);
        }
        out.writeVLong(this.nowInMillis);
        if (out.getVersion().onOrAfter(Version.V_1_4_0_Beta1)) {
            out.writeVInt(this.terminateAfter);
        }
    }
}

