/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query.functionscore.script;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.search.function.ScoreFunction;
import org.elasticsearch.common.lucene.search.function.ScriptScoreFunction;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParsingException;
import org.elasticsearch.index.query.functionscore.ScoreFunctionParser;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.script.SearchScript;

public class ScriptScoreFunctionParser
implements ScoreFunctionParser {
    public static String[] NAMES = new String[]{"script_score", "scriptScore"};

    @Inject
    public ScriptScoreFunctionParser() {
    }

    @Override
    public String[] getNames() {
        return NAMES;
    }

    @Override
    public ScoreFunction parse(QueryParseContext parseContext, XContentParser parser) throws IOException, QueryParsingException {
        XContentParser.Token token;
        String script = null;
        String scriptLang = null;
        Map<String, Object> vars = null;
        ScriptService.ScriptType scriptType = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if ("params".equals(currentFieldName)) {
                    vars = parser.map();
                    continue;
                }
                throw new QueryParsingException(parseContext.index(), NAMES[0] + " query does not support [" + currentFieldName + "]");
            }
            if (!token.isValue()) continue;
            if ("script".equals(currentFieldName)) {
                script = parser.text();
                continue;
            }
            if ("script_id".equals(currentFieldName)) {
                script = parser.text();
                scriptType = ScriptService.ScriptType.INDEXED;
                continue;
            }
            if ("file".equals(currentFieldName)) {
                script = parser.text();
                scriptType = ScriptService.ScriptType.FILE;
                continue;
            }
            if ("lang".equals(currentFieldName)) {
                scriptLang = parser.text();
                continue;
            }
            throw new QueryParsingException(parseContext.index(), NAMES[0] + " query does not support [" + currentFieldName + "]");
        }
        if (script == null) {
            throw new QueryParsingException(parseContext.index(), NAMES[0] + " requires 'script' field");
        }
        try {
            SearchScript searchScript = parseContext.scriptService().search(parseContext.lookup(), scriptLang, script, scriptType, vars);
            return new ScriptScoreFunction(script, vars, searchScript);
        }
        catch (Exception e) {
            throw new QueryParsingException(parseContext.index(), NAMES[0] + " the script could not be loaded", e);
        }
    }
}

