/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.impl;

import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cache2k.impl.DepthSearchAndSizeCounter;
import org.cache2k.impl.Entry;
import org.cache2k.impl.Hash;

public class CacheSizeEstimator {
    static final Log log = LogFactory.getLog(CacheSizeEstimator.class);
    final int MIN_ENTRY_COUNT = 3;
    final int ADDED_ENTRY_COUNT = 27;
    final int DEPTH_COUNT = 12;
    int accuracy;
    Random random;
    Entry lastEntry;
    Entry[] hash1;
    Entry[] hash2;

    final void switchHash() {
        Entry[] tmp = this.hash1;
        this.hash1 = this.hash2;
        this.hash2 = tmp;
    }

    final Entry nextEntry() {
        Entry e;
        if (this.lastEntry.another != null) {
            this.lastEntry = this.lastEntry.another;
            return this.lastEntry;
        }
        int idx = Hash.index(this.hash1, this.lastEntry.hashCode);
        do {
            if (++idx < this.hash1.length) continue;
            idx = 0;
        } while ((e = this.hash1[idx]) == null);
        this.lastEntry = e;
        return this.lastEntry;
    }

    final void findAnyEntry() {
        int idx = 0;
        while (this.hash1[idx] != null) {
            if (++idx < this.hash1.length) continue;
            idx = 0;
            this.switchHash();
        }
        this.lastEntry = this.hash1[idx];
    }

    final void randomizeStartEntry() {
        this.findAnyEntry();
        for (int _forward = this.random.nextInt(this.hash1.length + this.hash2.length); _forward != 0; --_forward) {
            this.nextEntry();
        }
    }

    final void addEntries(DepthSearchAndSizeCounter _counter, int _count) {
        for (int i = 0; i < _count; ++i) {
            _counter.insert(this.nextEntry().value);
            _counter.insert(this.nextEntry().key);
        }
    }

    final int getSizeEstimationForAnEntry() {
        try {
            DepthSearchAndSizeCounter cse = new DepthSearchAndSizeCounter();
            this.addEntries(cse, 27);
            for (int i = 0; i < 12 && cse.hasNext(); ++i) {
                cse.descend();
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("CSE: depth=" + i + ", counter=" + cse.getCounter() + ", objectCount=" + cse.getObjectCount() + ", memUsage=" + cse.getByteCount() + ", nextCnt=" + cse.next.size()));
            }
            this.accuracy = (cse.hasCircles() ? 1 : 0) + (cse.hasCommonObjects() ? 2 : 0) + (cse.hasNext() ? 4 : 0);
            return cse.getByteCount() / 27;
        }
        catch (DepthSearchAndSizeCounter.EstimationException ex) {
            StringBuilder sb = new StringBuilder();
            sb.append("Problems descending object tree for size estimation, path: ");
            for (Class<?> c : ex.getPath()) {
                sb.append(" -> ");
                sb.append(c.getSimpleName());
            }
            log.warn((Object)sb.toString(), ex.getCause());
            this.accuracy = 8;
            return 0;
        }
    }

    final int getAccuracy() {
        return this.accuracy;
    }
}

