/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.id;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.vertexium.util.IterableUtils;
import org.vertexium.util.VertexiumLogger;
import org.vertexium.util.VertexiumLoggerFactory;

public class SimpleSubstitutionUtils {
    private static final VertexiumLogger LOGGER = VertexiumLoggerFactory.getLogger(SimpleSubstitutionUtils.class);
    public static final String SUBSTITUTION_MAP_PREFIX = "substitution";
    public static final String KEY_IDENTIFIER = "key";
    public static final String VALUE_IDENTIFIER = "value";

    public static List<Pair<String, String>> getSubstitutionList(Map configuration) {
        HashMap substitutionMap = Maps.newHashMap();
        for (Object objKey : configuration.keySet()) {
            String key = objKey.toString();
            if (!key.startsWith("substitution.")) continue;
            ArrayList parts = Lists.newArrayList(IterableUtils.toList(Splitter.on((char)'.').split((CharSequence)key)));
            String pairKey = (String)parts.get(parts.size() - 2);
            String valueType = (String)parts.get(parts.size() - 1);
            if (!substitutionMap.containsKey(pairKey)) {
                substitutionMap.put(pairKey, new MutablePair());
            }
            MutablePair pair = (MutablePair)substitutionMap.get(pairKey);
            if (KEY_IDENTIFIER.equals(valueType)) {
                pair.setLeft((Object)configuration.get(key).toString());
                continue;
            }
            if (!VALUE_IDENTIFIER.equals(valueType)) continue;
            pair.setValue((Object)configuration.get(key).toString());
        }
        ArrayList keys = Lists.newArrayList(substitutionMap.keySet());
        Collections.sort(keys);
        ArrayList finalMap = Lists.newArrayList();
        for (String key : keys) {
            Pair pair = (Pair)substitutionMap.get(key);
            finalMap.add(pair);
            LOGGER.info("Using substitution %s -> %s", pair.getKey(), pair.getValue());
        }
        return finalMap;
    }
}

