/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.property;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.vertexium.Authorizations;
import org.vertexium.Metadata;
import org.vertexium.Property;
import org.vertexium.Visibility;
import org.vertexium.property.MutableProperty;
import org.vertexium.util.IncreasingTime;

public class MutablePropertyImpl
extends MutableProperty {
    private final String key;
    private final String name;
    private Set<Visibility> hiddenVisibilities;
    private Object value;
    private Visibility visibility;
    private long timestamp;
    private final Metadata metadata;

    public MutablePropertyImpl(String key, String name, Object value, Metadata metadata, Long timestamp, Set<Visibility> hiddenVisibilities, Visibility visibility) {
        if (metadata == null) {
            metadata = new Metadata();
        }
        this.key = key;
        this.name = name;
        this.value = value;
        this.metadata = metadata;
        this.timestamp = timestamp == null ? IncreasingTime.currentTimeMillis() : timestamp;
        this.visibility = visibility;
        this.hiddenVisibilities = hiddenVisibilities;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public Visibility getVisibility() {
        return this.visibility;
    }

    @Override
    public Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    public Iterable<Visibility> getHiddenVisibilities() {
        if (this.hiddenVisibilities == null) {
            return new ArrayList<Visibility>();
        }
        return this.hiddenVisibilities;
    }

    @Override
    public boolean isHidden(Authorizations authorizations) {
        if (this.hiddenVisibilities != null) {
            for (Visibility v : this.getHiddenVisibilities()) {
                if (!authorizations.canRead(v)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void setValue(Object value) {
        this.value = value;
    }

    @Override
    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    @Override
    public void setVisibility(Visibility visibility) {
        this.visibility = visibility;
    }

    @Override
    public void addHiddenVisibility(Visibility visibility) {
        if (this.hiddenVisibilities == null) {
            this.hiddenVisibilities = new HashSet<Visibility>();
        }
        this.hiddenVisibilities.add(visibility);
    }

    @Override
    public void removeHiddenVisibility(Visibility visibility) {
        if (this.hiddenVisibilities == null) {
            this.hiddenVisibilities = new HashSet<Visibility>();
        }
        this.hiddenVisibilities.remove(visibility);
    }

    @Override
    protected void updateMetadata(Property property) {
        ArrayList<Metadata.Entry> entries = new ArrayList<Metadata.Entry>(property.getMetadata().entrySet());
        this.metadata.clear();
        for (Metadata.Entry metadataEntry : entries) {
            this.metadata.add(metadataEntry.getKey(), metadataEntry.getValue(), metadataEntry.getVisibility());
        }
    }
}

