/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.query;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.vertexium.Element;
import org.vertexium.VertexiumException;
import org.vertexium.query.Aggregation;
import org.vertexium.query.AggregationResult;
import org.vertexium.query.CalendarFieldAggregation;
import org.vertexium.query.DefaultGraphQueryIterable;
import org.vertexium.query.HistogramBucket;
import org.vertexium.query.HistogramResult;
import org.vertexium.query.QueryParameters;
import org.vertexium.query.TermsAggregation;
import org.vertexium.query.TermsBucket;
import org.vertexium.query.TermsResult;

public class DefaultGraphQueryIterableWithAggregations<T extends Element>
extends DefaultGraphQueryIterable<T> {
    private final Collection<Aggregation> aggregations;

    public DefaultGraphQueryIterableWithAggregations(QueryParameters parameters, Iterable<T> iterable, boolean evaluateQueryString, boolean evaluateHasContainers, boolean evaluateSortContainers, Collection<Aggregation> aggregations) {
        super(parameters, iterable, evaluateQueryString, evaluateHasContainers, evaluateSortContainers);
        this.aggregations = aggregations;
    }

    @Override
    public <TResult extends AggregationResult> TResult getAggregationResult(String name, Class<? extends TResult> resultType) {
        for (Aggregation agg : this.aggregations) {
            if (!agg.getAggregationName().equals(name)) continue;
            return this.getAggregationResult(agg, this.iterator(true));
        }
        return super.getAggregationResult(name, resultType);
    }

    public static boolean isAggregationSupported(Aggregation agg) {
        if (agg instanceof TermsAggregation) {
            return true;
        }
        return agg instanceof CalendarFieldAggregation;
    }

    public <TResult extends AggregationResult> TResult getAggregationResult(Aggregation agg, Iterator<T> it) {
        if (agg instanceof TermsAggregation) {
            return (TResult)this.getTermsAggregationResult((TermsAggregation)agg, it);
        }
        if (agg instanceof CalendarFieldAggregation) {
            return (TResult)this.getCalendarFieldHistogramResult((CalendarFieldAggregation)agg, it);
        }
        throw new VertexiumException("Unhandled aggregation: " + agg.getClass().getName());
    }

    private TermsResult getTermsAggregationResult(TermsAggregation agg, Iterator<T> it) {
        String propertyName = agg.getPropertyName();
        Map<Object, List<T>> elementsByProperty = this.getElementsByProperty(it, propertyName, new IdentityValueConverter());
        ArrayList<TermsBucket> buckets = new ArrayList<TermsBucket>();
        for (Map.Entry<Object, List<T>> entry : elementsByProperty.entrySet()) {
            Object key = entry.getKey();
            int count = entry.getValue().size();
            Map<String, AggregationResult> nestedResults = this.getNestedResults(agg.getNestedAggregations(), entry.getValue());
            buckets.add(new TermsBucket(key, count, nestedResults));
        }
        return new TermsResult(buckets);
    }

    private HistogramResult getCalendarFieldHistogramResult(final CalendarFieldAggregation agg, Iterator<T> it) {
        String propertyName = agg.getPropertyName();
        final Calendar calendar = GregorianCalendar.getInstance(agg.getTimeZone());
        Map<Integer, List<T>> elementsByProperty = this.getElementsByProperty(it, propertyName, new ValueConverter<Integer>(){

            @Override
            public Integer convert(Object o) {
                Date d = (Date)o;
                calendar.setTime(d);
                return calendar.get(agg.getCalendarField());
            }
        });
        HashMap<Integer, HistogramBucket> buckets = new HashMap<Integer, HistogramBucket>(24);
        for (Map.Entry<Integer, List<T>> entry : elementsByProperty.entrySet()) {
            int key = entry.getKey();
            int count = entry.getValue().size();
            Map<String, AggregationResult> nestedResults = this.getNestedResults(agg.getNestedAggregations(), entry.getValue());
            buckets.put(key, new HistogramBucket(key, count, nestedResults));
        }
        return new HistogramResult(buckets.values());
    }

    private Map<String, AggregationResult> getNestedResults(Iterable<Aggregation> nestedAggregations, List<T> elements) {
        HashMap<String, AggregationResult> results = new HashMap<String, AggregationResult>();
        for (Aggregation nestedAggregation : nestedAggregations) {
            Object nestedResult = this.getAggregationResult(nestedAggregation, elements.iterator());
            results.put(nestedAggregation.getAggregationName(), (AggregationResult)nestedResult);
        }
        return results;
    }

    private <TKey> Map<TKey, List<T>> getElementsByProperty(Iterator<T> it, String propertyName, ValueConverter<TKey> valueConverter) {
        HashMap<TKey, ArrayList<Element>> elementsByProperty = new HashMap<TKey, ArrayList<Element>>();
        while (it.hasNext()) {
            Element elem = (Element)it.next();
            Iterable<Object> values = elem.getPropertyValues(propertyName);
            for (Object value : values) {
                TKey convertedValue = valueConverter.convert(value);
                ArrayList<Element> list = (ArrayList<Element>)elementsByProperty.get(convertedValue);
                if (list == null) {
                    list = new ArrayList<Element>();
                    elementsByProperty.put(convertedValue, list);
                }
                list.add(elem);
            }
        }
        return elementsByProperty;
    }

    private class IdentityValueConverter
    implements ValueConverter<Object> {
        private IdentityValueConverter() {
        }

        @Override
        public Object convert(Object o) {
            return o;
        }
    }

    private static interface ValueConverter<T> {
        public T convert(Object var1);
    }
}

