/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.type;

import java.io.Serializable;
import org.vertexium.VertexiumException;
import org.vertexium.type.GeoPoint;
import org.vertexium.type.GeoShape;

public class GeoCircle
implements Serializable,
GeoShape {
    private static final long serialVersionUID = 1L;
    private final double latitude;
    private final double longitude;
    private final double radius;
    private final String description;

    public GeoCircle(double latitude, double longitude, double radius) {
        this(latitude, longitude, radius, null);
    }

    public GeoCircle(double latitude, double longitude, double radius, String description) {
        this.latitude = latitude;
        this.longitude = longitude;
        this.radius = radius;
        this.description = description;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public double getRadius() {
        return this.radius;
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    public boolean within(GeoShape geoShape) {
        if (geoShape instanceof GeoPoint) {
            GeoPoint pt = (GeoPoint)geoShape;
            return GeoPoint.distanceBetween(this.getLatitude(), this.getLongitude(), pt.getLatitude(), pt.getLongitude()) <= this.getRadius();
        }
        if (geoShape instanceof GeoCircle) {
            GeoCircle circle = (GeoCircle)geoShape;
            double distance = GeoPoint.distanceBetween(this.getLatitude(), this.getLongitude(), circle.getLatitude(), circle.getLongitude());
            return distance <= this.getRadius() + circle.getRadius();
        }
        throw new VertexiumException("Not implemented for argument type " + geoShape.getClass().getName());
    }

    public int hashCode() {
        int hash = 7;
        hash = 61 * hash + (int)(Double.doubleToLongBits(this.latitude) ^ Double.doubleToLongBits(this.latitude) >>> 32);
        hash = 61 * hash + (int)(Double.doubleToLongBits(this.longitude) ^ Double.doubleToLongBits(this.longitude) >>> 32);
        hash = 61 * hash + (int)(Double.doubleToLongBits(this.radius) ^ Double.doubleToLongBits(this.radius) >>> 32);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GeoCircle other = (GeoCircle)obj;
        if (Double.doubleToLongBits(this.latitude) != Double.doubleToLongBits(other.latitude)) {
            return false;
        }
        if (Double.doubleToLongBits(this.longitude) != Double.doubleToLongBits(other.longitude)) {
            return false;
        }
        return Double.doubleToLongBits(this.radius) == Double.doubleToLongBits(other.radius);
    }

    public String toString() {
        return "GeoCircle[" + this.getLatitude() + ", " + this.getLongitude() + ", " + this.getRadius() + "]";
    }
}

