/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.type;

import java.util.HashMap;
import java.util.Map;
import org.vertexium.type.GeoPoint;
import org.vertexium.type.GeoRect;
import org.vertexium.type.GeoShape;

public class GeoHash
implements GeoShape {
    private static final char[] BASE32 = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'j', 'k', 'm', 'n', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    private static final int[] BITS = new int[]{16, 8, 4, 2, 1};
    private static final Map<Character, Integer> DECODE_MAP = new HashMap<Character, Integer>();
    private final String hash;

    public GeoHash(double latitude, double longitude, int precision) {
        this.hash = this.encode(latitude, longitude, precision);
    }

    public GeoHash(String hash) {
        this.hash = hash;
    }

    public String getHash() {
        return this.hash;
    }

    public String toString() {
        return "GeoHash{hash='" + this.hash + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeoHash geoHash = (GeoHash)o;
        return this.hash.equals(geoHash.hash);
    }

    public int hashCode() {
        return this.hash.hashCode();
    }

    private String encode(double latitude, double longitude, int precision) {
        double[] latInterval = new double[]{-90.0, 90.0};
        double[] lngInterval = new double[]{-180.0, 180.0};
        StringBuilder geohash = new StringBuilder();
        boolean isEven = true;
        int bit = 0;
        int ch = 0;
        while (geohash.length() < precision) {
            double mid;
            if (isEven) {
                mid = (lngInterval[0] + lngInterval[1]) / 2.0;
                if (longitude > mid) {
                    ch |= BITS[bit];
                    lngInterval[0] = mid;
                } else {
                    lngInterval[1] = mid;
                }
            } else {
                mid = (latInterval[0] + latInterval[1]) / 2.0;
                if (latitude > mid) {
                    ch |= BITS[bit];
                    latInterval[0] = mid;
                } else {
                    latInterval[1] = mid;
                }
            }
            boolean bl = isEven = !isEven;
            if (bit < 4) {
                ++bit;
                continue;
            }
            geohash.append(BASE32[ch]);
            bit = 0;
            ch = 0;
        }
        return geohash.toString();
    }

    public GeoRect toGeoRect() {
        double[] latInterval = new double[]{-90.0, 90.0};
        double[] lngInterval = new double[]{-180.0, 180.0};
        boolean isEven = true;
        for (int i = 0; i < this.hash.length(); ++i) {
            int cd = DECODE_MAP.get(Character.valueOf(this.hash.charAt(i)));
            for (int mask : BITS) {
                if (isEven) {
                    if ((cd & mask) != 0) {
                        lngInterval[0] = (lngInterval[0] + lngInterval[1]) / 2.0;
                    } else {
                        lngInterval[1] = (lngInterval[0] + lngInterval[1]) / 2.0;
                    }
                } else if ((cd & mask) != 0) {
                    latInterval[0] = (latInterval[0] + latInterval[1]) / 2.0;
                } else {
                    latInterval[1] = (latInterval[0] + latInterval[1]) / 2.0;
                }
                isEven = !isEven;
            }
        }
        GeoPoint nw = new GeoPoint(latInterval[1], lngInterval[0]);
        GeoPoint se = new GeoPoint(latInterval[0], lngInterval[1]);
        return new GeoRect(nw, se);
    }

    @Override
    public boolean within(GeoShape geoShape) {
        return this.toGeoRect().within(geoShape);
    }

    static {
        int sz = BASE32.length;
        for (int i = 0; i < sz; ++i) {
            DECODE_MAP.put(Character.valueOf(BASE32[i]), i);
        }
    }
}

