/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.common.primitives.Longs;
import com.thinkaurelius.titan.core.Cardinality;
import com.thinkaurelius.titan.core.EdgeLabel;
import com.thinkaurelius.titan.core.Multiplicity;
import com.thinkaurelius.titan.core.PropertyKey;
import com.thinkaurelius.titan.core.RelationType;
import com.thinkaurelius.titan.core.TitanEdge;
import com.thinkaurelius.titan.core.TitanElement;
import com.thinkaurelius.titan.core.TitanProperty;
import com.thinkaurelius.titan.core.TitanRelation;
import com.thinkaurelius.titan.core.TitanVertex;
import com.thinkaurelius.titan.graphdb.internal.ElementLifeCycle;
import com.thinkaurelius.titan.graphdb.internal.InternalElement;
import com.thinkaurelius.titan.graphdb.transaction.StandardTitanTx;
import com.thinkaurelius.titan.hadoop.FaunusEdge;
import com.thinkaurelius.titan.hadoop.FaunusEdgeLabel;
import com.thinkaurelius.titan.hadoop.FaunusProperty;
import com.thinkaurelius.titan.hadoop.FaunusPropertyKey;
import com.thinkaurelius.titan.hadoop.FaunusRelation;
import com.thinkaurelius.titan.hadoop.FaunusRelationType;
import com.thinkaurelius.titan.hadoop.FaunusSchemaManager;
import com.thinkaurelius.titan.hadoop.FaunusSerializer;
import com.thinkaurelius.titan.hadoop.FaunusVertex;
import com.thinkaurelius.titan.hadoop.FaunusVertexQuery;
import com.thinkaurelius.titan.hadoop.LifeCycleElement;
import com.thinkaurelius.titan.hadoop.StandardFaunusEdge;
import com.tinkerpop.blueprints.Direction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FaunusElement
extends LifeCycleElement
implements InternalElement,
Comparable<FaunusElement> {
    protected static final Predicate<FaunusProperty> FILTER_DELETED_PROPERTIES = new Predicate<FaunusProperty>(){

        public boolean apply(@Nullable FaunusProperty p) {
            return !p.isRemoved();
        }
    };
    protected static final Predicate<StandardFaunusEdge> FILTER_DELETED_EDGES = new Predicate<StandardFaunusEdge>(){

        public boolean apply(@Nullable StandardFaunusEdge e) {
            return !e.isRemoved();
        }
    };
    private static final Logger log = LoggerFactory.getLogger(FaunusElement.class);
    public static final long NO_ID = -1L;
    static final SetMultimap<FaunusRelationType, FaunusRelation> EMPTY_ADJACENCY = ImmutableSetMultimap.of();
    protected long id;
    protected SetMultimap<FaunusRelationType, FaunusRelation> outAdjacency = EMPTY_ADJACENCY;
    protected SetMultimap<FaunusRelationType, FaunusRelation> inAdjacency = EMPTY_ADJACENCY;

    public FaunusElement(long id) {
        this.id = id;
    }

    public abstract FaunusSchemaManager getTypeManager();

    public InternalElement it() {
        return this;
    }

    public StandardTitanTx tx() {
        throw new UnsupportedOperationException();
    }

    public void remove() throws UnsupportedOperationException {
        this.lifecycle = (byte)6;
        throw new UnsupportedOperationException();
    }

    public Object getId() {
        return this.id;
    }

    public long getLongId() {
        return this.id;
    }

    public boolean hasId() {
        return this.id >= 0L;
    }

    public void setId(long id) {
        Preconditions.checkArgument((id >= 0L ? 1 : 0) != 0);
        this.id = id;
    }

    void updateSchema(FaunusSerializer.Schema schema) {
        schema.addAll(this.inAdjacency.keySet());
        schema.addAll(this.outAdjacency.keySet());
    }

    public boolean isHidden() {
        return false;
    }

    @Override
    public boolean isModified() {
        if (super.isModified()) {
            return true;
        }
        if (!(this instanceof FaunusVertex)) {
            return false;
        }
        for (Direction dir : Direction.proper) {
            for (FaunusRelation r : this.getAdjacency(dir).values()) {
                if (!r.isModified()) continue;
                return true;
            }
        }
        return false;
    }

    protected Multiplicity getAdjustedMultiplicity(FaunusRelationType type) {
        if (this instanceof FaunusRelation) {
            return Multiplicity.MANY2ONE;
        }
        return type.getMultiplicity();
    }

    SetMultimap<FaunusRelationType, FaunusRelation> getAdjacency(Direction dir) {
        assert (dir == Direction.IN || dir == Direction.OUT);
        if (dir == Direction.IN) {
            return this.inAdjacency;
        }
        return this.outAdjacency;
    }

    protected void initializeAdjacency(Direction dir) {
        if ((dir == Direction.OUT || dir == Direction.BOTH) && this.outAdjacency == EMPTY_ADJACENCY) {
            this.outAdjacency = HashMultimap.create();
        }
        if ((dir == Direction.IN || dir == Direction.BOTH) && this.inAdjacency == EMPTY_ADJACENCY) {
            this.inAdjacency = HashMultimap.create();
        }
    }

    protected void setRelation(FaunusRelation relation) {
        int killedRels = 0;
        Iterator rels = this.outAdjacency.get((Object)relation.getType()).iterator();
        while (rels.hasNext()) {
            FaunusRelation r = (FaunusRelation)rels.next();
            if (r.isNew()) {
                rels.remove();
            }
            r.updateLifeCycle(ElementLifeCycle.Event.REMOVED);
            this.updateLifeCycle(ElementLifeCycle.Event.REMOVED_RELATION);
            ++killedRels;
        }
        Multiplicity adjMulti = this.getAdjustedMultiplicity(relation.getType());
        if (adjMulti != Multiplicity.MANY2ONE && 0 < killedRels) {
            log.info("setRelation deleted {} relations of type {} with multiplicity {}; use addRelation instead of setRelation to avoid deletion", new Object[]{killedRels, relation.getType(), adjMulti});
        }
        this.addRelation(relation);
    }

    protected FaunusRelation addRelation(final FaunusRelation relation) {
        Preconditions.checkNotNull((Object)relation);
        FaunusRelation old = null;
        for (Direction dir : Direction.proper) {
            FaunusEdge edge;
            if (relation.isProperty() && dir == Direction.IN || relation.isEdge() && ((edge = (FaunusEdge)relation).getEdgeLabel().isUnidirected() ? dir == Direction.IN : !edge.getVertex(dir).equals(this))) continue;
            this.initializeAdjacency(dir);
            SetMultimap<FaunusRelationType, FaunusRelation> adjacency = this.getAdjacency(dir);
            if (this instanceof FaunusVertex && adjacency.containsEntry((Object)relation.getType(), (Object)relation)) {
                old = (FaunusRelation)Iterables.getOnlyElement((Iterable)Iterables.filter((Iterable)adjacency.get((Object)relation.getType()), (Predicate)new Predicate<FaunusRelation>(){

                    public boolean apply(@Nullable FaunusRelation rel) {
                        return relation.equals(rel);
                    }
                }));
                if (relation.isNew() && old.isRemoved()) {
                    old.setLifeCycle((byte)2);
                    this.updateLifeCycle(ElementLifeCycle.Event.ADDED_RELATION);
                    continue;
                }
                if (!relation.isLoaded() || !old.isNew()) continue;
                old.setLifeCycle((byte)2);
                continue;
            }
            if (!relation.getType().isUnchecked()) {
                switch (relation.getType().getMultiplicity()) {
                    case MANY2ONE: {
                        if (dir != Direction.OUT) break;
                        FaunusElement.ensureUniqueness(relation.getType(), adjacency);
                        break;
                    }
                    case ONE2MANY: {
                        if (dir != Direction.IN) break;
                        FaunusElement.ensureUniqueness(relation.getType(), adjacency);
                        break;
                    }
                    case ONE2ONE: {
                        FaunusElement.ensureUniqueness(relation.getType(), adjacency);
                        break;
                    }
                    case SIMPLE: {
                        for (FaunusRelation rel : adjacency.get((Object)relation.getType())) {
                            if (rel.isRemoved()) continue;
                            if (relation.isEdge()) {
                                FaunusEdge e1 = (FaunusEdge)relation;
                                FaunusEdge e2 = (FaunusEdge)rel;
                                if (!e1.getVertex(Direction.OUT).equals(e2.getVertex(Direction.OUT)) || !e1.getVertex(Direction.IN).equals(e2.getVertex(Direction.IN))) continue;
                                throw new IllegalArgumentException("A relation already exists whichviolates the multiplicity constraint: " + relation.getType().getMultiplicity());
                            }
                            FaunusProperty p1 = (FaunusProperty)relation;
                            FaunusProperty p2 = (FaunusProperty)rel;
                            if (!p1.getValue().equals(p2.getValue())) continue;
                            throw new IllegalArgumentException("A relation already exists whichviolates the multiplicity constraint: " + relation.getType().getMultiplicity());
                        }
                        break;
                    }
                    case MULTI: {
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
            }
            adjacency.put((Object)relation.getType(), (Object)relation);
            this.updateLifeCycle(ElementLifeCycle.Event.ADDED_RELATION);
            log.trace("Added relation {} to {}", (Object)relation, (Object)this);
        }
        if (old != null) {
            return old;
        }
        return relation;
    }

    private static void ensureUniqueness(FaunusRelationType type, SetMultimap<FaunusRelationType, FaunusRelation> adjacency) {
        for (FaunusRelation rel : adjacency.get((Object)type)) {
            if (rel.isRemoved()) continue;
            throw new IllegalArgumentException("A relation already exists which violates the multiplicity constraint: " + type.getMultiplicity() + " on type " + (Object)((Object)type));
        }
    }

    public abstract FaunusVertexQuery query();

    public void setProperty(EdgeLabel label, TitanVertex vertex) {
        this.setProperty((FaunusRelationType)label, (Object)vertex);
    }

    public void setProperty(PropertyKey key, Object value) {
        this.setProperty((FaunusRelationType)key, value);
    }

    public void setProperty(String key, Object value) {
        FaunusPropertyKey rt = this.getTypeManager().getPropertyKey(key);
        if (rt == null) {
            rt = this.getTypeManager().getOrCreatePropertyKey(key);
        }
        this.setProperty(rt, value);
    }

    public abstract void setProperty(FaunusRelationType var1, Object var2);

    public <T> T removeProperty(String key) {
        FaunusPropertyKey rt = this.getTypeManager().getPropertyKey(key);
        if (rt == null) {
            return null;
        }
        return (T)this.removeProperty((RelationType)rt);
    }

    public <O> O removeProperty(RelationType type) {
        if (type.isEdgeLabel() && !(this instanceof FaunusVertex)) {
            throw new IllegalArgumentException("Provided argumentidentifies an edge label. Use edge methods to remove those: " + type);
        }
        if (this.outAdjacency.isEmpty()) {
            return null;
        }
        FaunusRelationType rtype = (FaunusRelationType)type;
        ArrayList removed = Lists.newArrayList();
        Iterator rels = this.outAdjacency.get((Object)rtype).iterator();
        while (rels.hasNext()) {
            FaunusRelation r = (FaunusRelation)rels.next();
            if (!r.isRemoved()) {
                if (r.isProperty()) {
                    removed.add(((FaunusProperty)r).getValue());
                } else {
                    removed.add(((FaunusEdge)r).getVertex(Direction.IN));
                }
            }
            if (r.isNew()) {
                rels.remove();
            }
            r.updateLifeCycle(ElementLifeCycle.Event.REMOVED);
            this.updateLifeCycle(ElementLifeCycle.Event.REMOVED_RELATION);
        }
        if (removed.isEmpty()) {
            return null;
        }
        if (this.getAdjustedMultiplicity(rtype) == Multiplicity.MANY2ONE) {
            return (O)removed.iterator().next();
        }
        return (O)removed;
    }

    public TitanVertex getProperty(EdgeLabel label) {
        Preconditions.checkArgument((label != null ? 1 : 0) != 0);
        Preconditions.checkArgument((!(this instanceof FaunusVertex) ? 1 : 0) != 0, (Object)"Use getEdges() to query for edges on a vertex");
        return ((TitanEdge)Iterables.getOnlyElement(((FaunusVertexQuery)this.query().type((RelationType)label)).titanEdges())).getVertex(Direction.IN);
    }

    public <T> T getProperty(PropertyKey key) {
        FaunusPropertyKey type = (FaunusPropertyKey)key;
        Iterator<TitanProperty> properties = ((FaunusVertexQuery)this.query().type((RelationType)type)).properties().iterator();
        if (type.getCardinality() == Cardinality.SINGLE) {
            if (properties.hasNext()) {
                return (T)properties.next().getValue();
            }
            return (T)((Object)null);
        }
        ArrayList result = Lists.newArrayList();
        while (properties.hasNext()) {
            result.add(properties.next().getValue());
        }
        return (T)result;
    }

    public <T> T getProperty(String key) {
        FaunusPropertyKey rt = this.getTypeManager().getPropertyKey(key);
        if (rt == null) {
            return null;
        }
        if (rt.isPropertyKey()) {
            return this.getProperty(rt);
        }
        return (T)this.getProperty((FaunusEdgeLabel)((Object)rt));
    }

    public Set<String> getPropertyKeys() {
        return Sets.newHashSet((Iterable)Iterables.transform(this.getPropertyKeysDirect(), (Function)new Function<RelationType, String>(){

            @Nullable
            public String apply(@Nullable RelationType relationType) {
                return relationType.getName();
            }
        }));
    }

    protected Iterable<RelationType> getPropertyKeysDirect() {
        HashSet result = Sets.newHashSet();
        for (TitanRelation r : this.query().relations()) {
            if (r.isEdge()) continue;
            result.add(r.getType());
        }
        return result;
    }

    public void addAllProperties(Iterable<FaunusRelation> properties) {
        for (FaunusRelation p : properties) {
            this.addRelation(p);
        }
    }

    public Collection<FaunusRelation> getPropertyCollection() {
        return Lists.newArrayList(this instanceof FaunusVertex ? this.query().properties() : this.query().relations());
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !(other instanceof TitanElement)) {
            return false;
        }
        TitanElement o = (TitanElement)other;
        if (!this.hasId() || !o.hasId()) {
            return o == this;
        }
        return this.getLongId() == o.getLongId();
    }

    public int hashCode() {
        return Long.valueOf(this.id).hashCode();
    }

    @Override
    public int compareTo(FaunusElement o) {
        return Longs.compare((long)this.id, (long)o.getLongId());
    }
}

