/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop.formats.cassandra;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.diskstorage.StaticBuffer;
import com.thinkaurelius.titan.diskstorage.util.StaticArrayBuffer;
import com.thinkaurelius.titan.hadoop.FaunusVertexQueryFilter;
import com.thinkaurelius.titan.hadoop.formats.cassandra.TitanCassandraHadoopGraph;
import com.thinkaurelius.titan.hadoop.formats.cassandra.TitanCassandraInputFormat;
import com.thinkaurelius.titan.hadoop.formats.cassandra.TitanCassandraRecordReader;
import com.thinkaurelius.titan.hadoop.formats.util.TitanHadoopGraph;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.cassandra.hadoop.ColumnFamilyRecordReader;

public class TitanCassandraWideRecordReader
extends TitanCassandraRecordReader {
    private TitanHadoopGraph.VertexBuilder vb = null;

    public TitanCassandraWideRecordReader(TitanCassandraInputFormat inputFormat, FaunusVertexQueryFilter vertexQuery, ColumnFamilyRecordReader reader) {
        super(inputFormat, vertexQuery, reader);
    }

    @Override
    public boolean nextKeyValue() throws IOException, InterruptedException {
        while (this.reader.nextKeyValue()) {
            StaticArrayBuffer key = StaticArrayBuffer.of((ByteBuffer)this.reader.getCurrentKey().duplicate());
            TitanCassandraHadoopGraph.CassandraMapIterable columns = new TitanCassandraHadoopGraph.CassandraMapIterable(this.reader.getCurrentValue());
            if (null == this.vb) {
                this.vb = this.graph.newVertexBuilder(this.configuration, (StaticBuffer)key);
                Preconditions.checkArgument((boolean)this.vb.getKey().equals(key));
            } else if (!this.vb.getKey().equals(key)) {
                this.vertex = this.vb.build();
                this.vertexQuery.filterRelationsOf(this.vertex);
                this.vb = this.graph.newVertexBuilder(this.configuration, (StaticBuffer)key);
                if (null != this.vertex) {
                    return true;
                }
            }
            this.vb.addEntries(columns);
        }
        if (null != this.vb) {
            this.vertex = this.vb.build();
            this.vertexQuery.filterRelationsOf(this.vertex);
            this.vb = null;
            return null != this.vertex;
        }
        return false;
    }
}

