/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.PrintWriter;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.protocol.QuotaExceededException;
import org.apache.hadoop.hdfs.server.namenode.Content;
import org.apache.hadoop.hdfs.server.namenode.ContentSummaryComputationContext;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.INodeMap;
import org.apache.hadoop.hdfs.server.namenode.INodeWithAdditionalFields;
import org.apache.hadoop.hdfs.server.namenode.Quota;
import org.apache.hadoop.hdfs.server.namenode.snapshot.Snapshot;

@InterfaceAudience.Private
public class INodeSymlink
extends INodeWithAdditionalFields {
    private final byte[] symlink;

    INodeSymlink(long id, byte[] name, PermissionStatus permissions, long mtime, long atime, String symlink) {
        super(id, name, permissions, mtime, atime);
        this.symlink = DFSUtil.string2Bytes(symlink);
    }

    INodeSymlink(INodeSymlink that) {
        super(that);
        this.symlink = that.symlink;
    }

    @Override
    INode recordModification(Snapshot latest, INodeMap inodeMap) throws QuotaExceededException {
        if (this.isInLatestSnapshot(latest)) {
            INodeDirectory parent = this.getParent();
            parent.saveChild2Snapshot(this, latest, new INodeSymlink(this), inodeMap);
        }
        return this;
    }

    @Override
    public boolean isSymlink() {
        return true;
    }

    @Override
    public INodeSymlink asSymlink() {
        return this;
    }

    public String getSymlinkString() {
        return DFSUtil.bytes2String(this.symlink);
    }

    public byte[] getSymlink() {
        return this.symlink;
    }

    @Override
    public Quota.Counts cleanSubtree(Snapshot snapshot, Snapshot prior, INode.BlocksMapUpdateInfo collectedBlocks, List<INode> removedINodes, boolean countDiffChange) {
        if (snapshot == null && prior == null) {
            this.destroyAndCollectBlocks(collectedBlocks, removedINodes);
        }
        return Quota.Counts.newInstance(1L, 0L);
    }

    @Override
    public void destroyAndCollectBlocks(INode.BlocksMapUpdateInfo collectedBlocks, List<INode> removedINodes) {
        removedINodes.add(this);
    }

    @Override
    public Quota.Counts computeQuotaUsage(Quota.Counts counts, boolean updateCache, int lastSnapshotId) {
        counts.add(Quota.NAMESPACE, 1L);
        return counts;
    }

    @Override
    public ContentSummaryComputationContext computeContentSummary(ContentSummaryComputationContext summary) {
        summary.getCounts().add(Content.SYMLINK, 1L);
        return summary;
    }

    @Override
    public void dumpTreeRecursively(PrintWriter out, StringBuilder prefix, Snapshot snapshot) {
        super.dumpTreeRecursively(out, prefix, snapshot);
        out.println();
    }
}

