/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.sql;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.vertexium.VertexiumSerializer;
import org.vertexium.inmemory.InMemoryEdge;
import org.vertexium.inmemory.InMemoryGraphConfiguration;
import org.vertexium.inmemory.InMemoryTableElement;
import org.vertexium.inmemory.InMemoryVertex;
import org.vertexium.sql.SqlStreamingPropertyTable;
import org.vertexium.sql.SqlTableEdge;
import org.vertexium.sql.collections.SqlMap;

public class SqlGraphConfiguration
extends InMemoryGraphConfiguration {
    protected static final String KEY_COLUMN_NAME = "id";
    protected static final String VALUE_COLUMN_NAME = "object";
    protected static final String VERTEX_TABLE_NAME = "vertex";
    protected static final String EDGE_TABLE_NAME = "edge";
    protected static final String METADATA_TABLE_NAME = "metadata";
    protected static final String STREAMING_PROPERTIES_TABLE_NAME = "streaming_properties";
    protected static final String IN_VERTEX_ID_COLUMN = "in_vertex_id";
    protected static final String OUT_VERTEX_ID_COLUMN = "out_vertex_id";
    private static final String CONFIG_PREFIX = "sql.";
    private final DataSource dataSource;
    private final VertexiumSerializer serializer;

    public SqlGraphConfiguration(Map<String, Object> config) {
        super(config);
        this.dataSource = this.createDataSource(config);
        this.serializer = this.createSerializer();
    }

    private DataSource createDataSource(Map<String, Object> config) {
        Properties properties = new Properties();
        for (Map.Entry<String, Object> configEntry : config.entrySet()) {
            String key = configEntry.getKey();
            if (!key.startsWith(CONFIG_PREFIX)) continue;
            key = key.substring(CONFIG_PREFIX.length());
            properties.put(key, configEntry.getValue());
        }
        HikariConfig hikariConfig = new HikariConfig(properties);
        return new HikariDataSource(hikariConfig);
    }

    protected DataSource getDataSource() {
        return this.dataSource;
    }

    protected String tableNameWithPrefix(String tableName) {
        return this.getTableNamePrefix() + "_" + tableName;
    }

    protected SqlMap<InMemoryTableElement<InMemoryEdge>> newEdgeMap() {
        return new SqlMap<InMemoryTableElement<InMemoryEdge>>(this.tableNameWithPrefix(EDGE_TABLE_NAME), KEY_COLUMN_NAME, VALUE_COLUMN_NAME, this.dataSource, this.serializer){

            @Override
            protected Map<String, Object> additionalColumns(String key, InMemoryTableElement<InMemoryEdge> value) {
                SqlTableEdge edge = (SqlTableEdge)value;
                HashMap<String, Object> columns = new HashMap<String, Object>();
                columns.put(SqlGraphConfiguration.IN_VERTEX_ID_COLUMN, edge.inVertexId());
                columns.put(SqlGraphConfiguration.OUT_VERTEX_ID_COLUMN, edge.outVertexId());
                return columns;
            }
        };
    }

    protected SqlMap<InMemoryTableElement<InMemoryVertex>> newVertexMap() {
        return new SqlMap<InMemoryTableElement<InMemoryVertex>>(this.tableNameWithPrefix(VERTEX_TABLE_NAME), KEY_COLUMN_NAME, VALUE_COLUMN_NAME, this.dataSource, this.serializer);
    }

    protected SqlMap<Object> newMetadataMap() {
        return new SqlMap<Object>(this.tableNameWithPrefix(METADATA_TABLE_NAME), KEY_COLUMN_NAME, VALUE_COLUMN_NAME, this.dataSource, this.serializer);
    }

    protected SqlStreamingPropertyTable newStreamingPropertyTable() {
        return new SqlStreamingPropertyTable(this.tableNameWithPrefix(STREAMING_PROPERTIES_TABLE_NAME), this.dataSource);
    }
}

