/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.sql;

import java.util.Map;
import org.vertexium.Authorizations;
import org.vertexium.Graph;
import org.vertexium.Metadata;
import org.vertexium.Property;
import org.vertexium.Visibility;
import org.vertexium.inmemory.InMemoryElement;
import org.vertexium.inmemory.InMemoryTableElement;
import org.vertexium.inmemory.mutations.Mutation;
import org.vertexium.property.StreamingPropertyValue;
import org.vertexium.property.StreamingPropertyValueRef;
import org.vertexium.sql.SqlGraph;
import org.vertexium.sql.collections.Storable;

public abstract class SqlTableElement<TElement extends InMemoryElement>
extends InMemoryTableElement<TElement>
implements Storable<SqlTableElement<TElement>, SqlGraph> {
    private transient Map<String, SqlTableElement<TElement>> container;
    private transient SqlGraph graph;

    @Override
    public void setContainer(Map<String, SqlTableElement<TElement>> container, SqlGraph graph) {
        this.container = container;
        this.graph = graph;
    }

    @Override
    public void store() {
        this.container.put(this.getId(), this);
    }

    protected SqlTableElement(String id) {
        super(id);
    }

    abstract InMemoryTableElement<TElement> asInMemoryTableElement();

    public void addAll(Mutation ... newMutations) {
        super.addAll(newMutations);
        this.store();
    }

    protected void deleteProperty(Property p) {
        super.deleteProperty(p);
        this.store();
    }

    public void appendSoftDeleteMutation(Long timestamp) {
        super.appendSoftDeleteMutation(timestamp);
        this.store();
    }

    public void appendMarkHiddenMutation(Visibility visibility) {
        super.appendMarkHiddenMutation(visibility);
        this.store();
    }

    public void appendMarkVisibleMutation(Visibility visibility) {
        super.appendMarkVisibleMutation(visibility);
        this.store();
    }

    public Property appendMarkPropertyHiddenMutation(String key, String name, Visibility propertyVisibility, Long timestamp, Visibility visibility, Authorizations authorizations) {
        Property prop = super.appendMarkPropertyHiddenMutation(key, name, propertyVisibility, timestamp, visibility, authorizations);
        this.store();
        return prop;
    }

    public Property appendMarkPropertyVisibleMutation(String key, String name, Visibility propertyVisibility, Long timestamp, Visibility visibility, Authorizations authorizations) {
        Property prop = super.appendMarkPropertyVisibleMutation(key, name, propertyVisibility, timestamp, visibility, authorizations);
        this.store();
        return prop;
    }

    public void appendSoftDeletePropertyMutation(String key, String name, Visibility propertyVisibility, Long timestamp) {
        super.appendSoftDeletePropertyMutation(key, name, propertyVisibility, timestamp);
        this.store();
    }

    public void appendAlterVisibilityMutation(Visibility newVisibility) {
        super.appendAlterVisibilityMutation(newVisibility);
        this.store();
    }

    public void appendAddPropertyMutation(String key, String name, Object value, Metadata metadata, Visibility visibility, Long timestamp) {
        super.appendAddPropertyMutation(key, name, value, metadata, visibility, timestamp);
        this.store();
    }

    public void appendAlterEdgeLabelMutation(String newEdgeLabel) {
        super.appendAlterEdgeLabelMutation(newEdgeLabel);
        this.store();
    }

    protected StreamingPropertyValue loadStreamingPropertyValue(StreamingPropertyValueRef<?> streamingPropertyValueRef) {
        return streamingPropertyValueRef.toStreamingPropertyValue((Graph)this.graph);
    }
}

