/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.accumulo.iterator.model;

import org.apache.hadoop.io.Text;
import org.vertexium.accumulo.iterator.model.KeyBase;
import org.vertexium.accumulo.iterator.model.PropertyColumnQualifier;

public class PropertyMetadataColumnQualifier
extends KeyBase {
    public static final int PART_INDEX_PROPERTY_NAME = 0;
    public static final int PART_INDEX_PROPERTY_KEY = 1;
    public static final int PART_INDEX_PROPERTY_VISIBILITY = 2;
    public static final int PART_INDEX_METADATA_KEY = 3;
    private final String[] parts;

    public PropertyMetadataColumnQualifier(Text columnQualifier) {
        this.parts = PropertyMetadataColumnQualifier.splitOnValueSeparator(columnQualifier.toString(), 4);
    }

    public PropertyMetadataColumnQualifier(String propertyName, String propertyKey, String visibilityString, String metadataKey) {
        this.parts = new String[]{propertyName, propertyKey, visibilityString, metadataKey};
    }

    public PropertyColumnQualifier getPropertyColumnQualifier() {
        return new PropertyColumnQualifier(this.getPropertyName(), this.getPropertyKey());
    }

    public String getPropertyName() {
        return this.parts[0];
    }

    public String getPropertyKey() {
        return this.parts[1];
    }

    public String getPropertyVisibilityString() {
        return this.parts[2];
    }

    public String getMetadataKey() {
        return this.parts[3];
    }

    public String getPropertyDiscriminator(long propertyTimestamp) {
        return this.getPropertyColumnQualifier().getDiscriminator(this.getPropertyVisibilityString(), propertyTimestamp);
    }
}

