/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.cache2k.StorageConfiguration;

public class CacheConfig {
    private String name;
    private Class<?> keyType = Object.class;
    private Class<?> valueType = Object.class;
    private Class<?> entryType;
    private Class<?> implementation;
    private int maxSize = 2000;
    private int maxSizeHighBound = Integer.MAX_VALUE;
    private int maxSizeLowBound = 0;
    private int heapEntryCapacity = -1;
    private boolean backgroundRefresh = false;
    private long expiryMillis = 600000L;
    private long exceptionExpiryMillis = -1L;
    private boolean keepDataAfterExpired = true;
    private boolean sharpExpiry = false;
    private List<Object> moduleConfiguration;
    private boolean suppressExceptions = true;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }

    public int getMaxSizeHighBound() {
        return this.maxSizeHighBound;
    }

    public void setMaxSizeHighBound(int maxSizeHighBound) {
        if (this.maxSize > maxSizeHighBound) {
            this.maxSize = maxSizeHighBound;
        }
        this.maxSizeHighBound = maxSizeHighBound;
    }

    public int getMaxSizeLowBound() {
        return this.maxSizeLowBound;
    }

    public void setMaxSizeLowBound(int maxSizeLowBound) {
        if (this.maxSize < maxSizeLowBound) {
            this.maxSize = maxSizeLowBound;
        }
        this.maxSizeLowBound = maxSizeLowBound;
    }

    public boolean isBackgroundRefresh() {
        return this.backgroundRefresh;
    }

    public void setBackgroundRefresh(boolean backgroundRefresh) {
        this.backgroundRefresh = backgroundRefresh;
    }

    public Class<?> getKeyType() {
        return this.keyType;
    }

    public void setKeyType(Class<?> keyType) {
        if (keyType == null) {
            throw new NullPointerException("null key type not allowed");
        }
        this.keyType = keyType;
    }

    public Class<?> getValueType() {
        return this.valueType;
    }

    public Class<?> getEntryType() {
        return this.entryType;
    }

    public void setEntryType(Class<?> entryType) {
        this.entryType = entryType;
    }

    public void setValueType(Class<?> valueType) {
        if (valueType == null) {
            throw new NullPointerException("null value type not allowed");
        }
        this.valueType = valueType;
    }

    public boolean isEternal() {
        return this.expiryMillis == -1L || this.expiryMillis == Long.MAX_VALUE;
    }

    public void setEternal(boolean v) {
        if (v) {
            this.expiryMillis = -1L;
        }
    }

    public void setExpirySeconds(int v) {
        if (v == -1 || v == Integer.MAX_VALUE) {
            this.expiryMillis = -1L;
        }
        this.expiryMillis = v * 1000;
    }

    public int getExpirySeconds() {
        if (this.isEternal()) {
            return -1;
        }
        return (int)(this.expiryMillis / 1000L);
    }

    public long getExpiryMillis() {
        return this.expiryMillis;
    }

    public void setExpiryMillis(long expiryMillis) {
        this.expiryMillis = expiryMillis;
    }

    public long getExceptionExpiryMillis() {
        return this.exceptionExpiryMillis;
    }

    public void setExceptionExpiryMillis(long v) {
        this.exceptionExpiryMillis = v;
    }

    public boolean isKeepDataAfterExpired() {
        return this.keepDataAfterExpired;
    }

    public void setKeepDataAfterExpired(boolean v) {
        this.keepDataAfterExpired = v;
    }

    public boolean isSharpExpiry() {
        return this.sharpExpiry;
    }

    public void setSharpExpiry(boolean sharpExpiry) {
        this.sharpExpiry = sharpExpiry;
    }

    public boolean isSuppressExceptions() {
        return this.suppressExceptions;
    }

    public void setSuppressExceptions(boolean suppressExceptions) {
        this.suppressExceptions = suppressExceptions;
    }

    public int getHeapEntryCapacity() {
        return this.heapEntryCapacity;
    }

    public void setHeapEntryCapacity(int v) {
        this.heapEntryCapacity = v;
    }

    public List<Object> getModuleConfiguration() {
        return this.moduleConfiguration;
    }

    public void setModuleConfiguration(List<Object> moduleConfiguration) {
        this.moduleConfiguration = moduleConfiguration;
    }

    public Class<?> getImplementation() {
        return this.implementation;
    }

    public void setImplementation(Class<?> cacheImplementation) {
        this.implementation = cacheImplementation;
    }

    public List<StorageConfiguration> getStorageModules() {
        if (this.moduleConfiguration == null) {
            return Collections.emptyList();
        }
        ArrayList<StorageConfiguration> l = new ArrayList<StorageConfiguration>();
        for (Object o : this.moduleConfiguration) {
            if (!(o instanceof StorageConfiguration)) continue;
            l.add((StorageConfiguration)o);
        }
        return l;
    }
}

