/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.algebra.evaluation.limited.iterator;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.algebra.Join;
import org.openrdf.query.algebra.evaluation.EvaluationStrategy;
import org.openrdf.query.algebra.evaluation.iterator.BottomUpJoinIterator;

public class LimitedSizeBottomUpJoinIterator
extends BottomUpJoinIterator {
    private static final String SIZE_LIMIT_REACHED = "Size limited reached inside bottom up join operator, max size is:";
    private AtomicLong used;
    private long maxSize;

    public LimitedSizeBottomUpJoinIterator(EvaluationStrategy limitedSizeEvaluationStrategy, Join join, BindingSet bindings, AtomicLong used, long maxSize) throws QueryEvaluationException {
        super(limitedSizeEvaluationStrategy, join, bindings);
        this.used = used;
        this.maxSize = maxSize;
    }

    @Override
    protected void addAll(List<BindingSet> hashTableValues, List<BindingSet> values) throws QueryEvaluationException {
        Iterator<BindingSet> iter = values.iterator();
        while (iter.hasNext()) {
            if (!hashTableValues.add(iter.next()) || this.used.incrementAndGet() <= this.maxSize) continue;
            throw new QueryEvaluationException(SIZE_LIMIT_REACHED + this.maxSize);
        }
    }

    @Override
    protected void add(List<BindingSet> leftArgResults, BindingSet b) throws QueryEvaluationException {
        if (leftArgResults.add(b) && this.used.incrementAndGet() > this.maxSize) {
            throw new QueryEvaluationException(SIZE_LIMIT_REACHED + this.maxSize);
        }
    }

    @Override
    protected BindingSet removeFirstElement(List<BindingSet> list) throws QueryEvaluationException {
        this.used.decrementAndGet();
        return super.removeFirstElement(list);
    }

    @Override
    protected void put(Map<BindingSet, List<BindingSet>> hashTable, BindingSet hashKey, List<BindingSet> hashValue) throws QueryEvaluationException {
        List<BindingSet> put = hashTable.put(hashKey, hashValue);
        if (put == null && this.used.incrementAndGet() > this.maxSize) {
            throw new QueryEvaluationException(SIZE_LIMIT_REACHED + this.maxSize);
        }
    }

    @Override
    protected void handleClose() throws QueryEvaluationException {
        long htvSize = this.clearHashTable();
        super.handleClose();
        this.used.addAndGet(-htvSize);
    }
}

