/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.junitbenchmarks.db;

import com.carrotsearch.junitbenchmarks.Escape;
import com.carrotsearch.junitbenchmarks.annotation.AxisRange;
import com.carrotsearch.junitbenchmarks.annotation.LabelType;
import com.carrotsearch.junitbenchmarks.db.DbConsumer;
import com.carrotsearch.junitbenchmarks.db.GeneratorUtils;
import java.io.File;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Locale;

public final class HistoryChartGenerator {
    private static EnumMap<LabelType, Integer> labelColumns = new EnumMap(LabelType.class);
    private DbConsumer consumer;
    private String clazzName;
    private ArrayList<String> methods = new ArrayList();
    private int maxRuns = Integer.MIN_VALUE;
    private String filePrefix;
    private double min = Double.NaN;
    private double max = Double.NaN;
    private final LabelType labelType;

    public HistoryChartGenerator(String filePrefix, String clazzName, LabelType labelType, DbConsumer consumer) {
        this.clazzName = clazzName;
        this.filePrefix = filePrefix;
        this.labelType = labelType;
        this.consumer = consumer;
    }

    public void generate() throws Exception {
        String jsonFileName = this.filePrefix + ".jsonp";
        String htmlFileName = this.filePrefix + ".html";
        String template = this.consumer.getHistoryHtmlTemplate();
        template = GeneratorUtils.replaceToken(template, "CLASSNAME", this.clazzName);
        template = GeneratorUtils.replaceToken(template, "HistoryChartGenerator.jsonp", new File(jsonFileName).getName());
        template = GeneratorUtils.replaceToken(template, "/*MINMAX*/", GeneratorUtils.getMinMax(this.min, this.max));
        template = GeneratorUtils.replaceToken(template, "/*LABELCOLUMN*/", Integer.toString(labelColumns.get((Object)this.labelType)));
        template = GeneratorUtils.replaceToken(template, "PROPERTIES", this.getProperties());
        GeneratorUtils.save(htmlFileName, template);
        GeneratorUtils.save(jsonFileName, this.getData());
    }

    private String getProperties() {
        return "Shows historical runs: " + (this.maxRuns == Integer.MAX_VALUE ? "all" : Integer.valueOf(this.maxRuns));
    }

    private String getData() throws SQLException {
        PreparedStatement s;
        String methodsRestrictionClause = "";
        if (this.methods.size() > 0) {
            StringBuilder b = new StringBuilder();
            b.append(" AND NAME IN (");
            for (int i = 0; i < this.methods.size(); ++i) {
                if (i > 0) {
                    b.append(", ");
                }
                b.append("'");
                b.append(Escape.sqlEscape(this.methods.get(i)));
                b.append("'");
            }
            b.append(")");
            methodsRestrictionClause = b.toString();
        }
        int minRunId = 0;
        if (this.maxRuns != Integer.MAX_VALUE) {
            s = this.consumer.getConnection().prepareStatement("SELECT DISTINCT RUN_ID FROM TESTS t, RUNS r  WHERE t.classname = ?  AND t.run_id = r.id " + methodsRestrictionClause + " ORDER BY RUN_ID DESC " + " LIMIT ?");
            s.setString(1, this.clazzName);
            s.setInt(2, this.maxRuns);
            ResultSet rs = s.executeQuery();
            if (rs.last()) {
                minRunId = rs.getInt(1);
            }
            s.close();
        }
        s = this.consumer.getConnection().prepareStatement("SELECT DISTINCT NAME FROM TESTS t, RUNS r  WHERE t.classname = ?  AND t.run_id = r.id " + methodsRestrictionClause + " AND r.id >= ? " + " ORDER BY NAME ");
        s.setString(1, this.clazzName);
        s.setInt(2, minRunId);
        ArrayList<String> columnNames = new ArrayList<String>();
        ResultSet rs = s.executeQuery();
        while (rs.next()) {
            columnNames.add(rs.getString(1));
        }
        StringBuilder buf = new StringBuilder();
        buf.append("receiveJsonpData({\n");
        buf.append("\"cols\": [\n");
        buf.append("{\"label\": \"Run\", \"type\": \"string\"},\n");
        buf.append("{\"label\": \"Custom key\", \"type\": \"string\"},\n");
        buf.append("{\"label\": \"Timestamp\", \"type\": \"string\"}");
        for (int i = 0; i < columnNames.size(); ++i) {
            buf.append(",\n");
            buf.append("{\"label\": \"");
            buf.append(Escape.jsonEscape((String)columnNames.get(i)));
            buf.append("\", \"type\": \"string\"} ");
        }
        buf.append("],\n");
        s = this.consumer.getConnection().prepareStatement("SELECT RUN_ID, CUSTOM_KEY, TSTAMP, NAME, ROUND_AVG FROM TESTS t, RUNS r WHERE t.classname = ?  AND t.run_id = r.id " + methodsRestrictionClause + " AND r.id >= ? " + "ORDER BY r.id ASC, NAME ASC");
        s.setString(1, this.clazzName);
        s.setInt(2, minRunId);
        rs = s.executeQuery();
        NumberFormat nf = NumberFormat.getInstance(Locale.ENGLISH);
        nf.setMaximumFractionDigits(3);
        nf.setGroupingUsed(false);
        HashMap<String, StringHolder> byColumn = new HashMap<String, StringHolder>();
        ArrayList<StringHolder> row = new ArrayList<StringHolder>();
        row.add(new StringHolder(null));
        row.add(new StringHolder(null));
        row.add(new StringHolder(null));
        for (String name : columnNames) {
            StringHolder nv = new StringHolder(null);
            row.add(nv);
            byColumn.put(name, nv);
        }
        int colRunId = GeneratorUtils.getColumnIndex(rs, "RUN_ID");
        int colName = GeneratorUtils.getColumnIndex(rs, "NAME");
        int colRoundAvg = GeneratorUtils.getColumnIndex(rs, "ROUND_AVG");
        int colCustomKey = GeneratorUtils.getColumnIndex(rs, "CUSTOM_KEY");
        int colTimestamp = GeneratorUtils.getColumnIndex(rs, "TSTAMP");
        int previousRowId = -1;
        buf.append("\"rows\": [\n");
        while (rs.next()) {
            int rowId = rs.getInt(colRunId);
            if (rs.isFirst()) {
                previousRowId = rowId;
            }
            if (rowId != previousRowId) {
                this.emitRow(buf, row, false);
                previousRowId = rowId;
            }
            String name = rs.getString(colName);
            double avg = rs.getDouble(colRoundAvg);
            String customKey = rs.getString(colCustomKey);
            String timestamp = rs.getTimestamp(colTimestamp).toString();
            String runName = Integer.toString(rowId);
            row.get((int)0).value = '\"' + runName + '\"';
            row.get((int)1).value = '\"' + (customKey == null ? "[" + runName + "]" : customKey) + '\"';
            row.get((int)2).value = '\"' + timestamp + '\"';
            StringHolder nv = (StringHolder)byColumn.get(name);
            if (nv == null) {
                throw new RuntimeException("Missing column: " + name);
            }
            nv.value = nf.format(avg);
            if (!rs.isLast()) continue;
            this.emitRow(buf, row, rs.isLast());
        }
        buf.append("]});\n");
        return buf.toString();
    }

    private void emitRow(StringBuilder buf, ArrayList<StringHolder> row, boolean last) {
        buf.append("{\"c\": [");
        for (int i = 0; i < row.size(); ++i) {
            StringHolder nv = row.get(i);
            buf.append("{\"v\": ");
            buf.append(nv.value);
            buf.append("}");
            if (i + 1 >= row.size()) continue;
            buf.append(", ");
        }
        buf.append("]}");
        if (!last) {
            buf.append(",");
        }
        buf.append('\n');
        for (StringHolder nv : row) {
            nv.value = null;
        }
    }

    public void includeMethod(String methodName) {
        this.methods.add(methodName);
    }

    public void updateMaxRuns(int newMax) {
        this.maxRuns = Math.max(newMax, this.maxRuns);
    }

    public void updateMinMax(AxisRange r) {
        if (Double.isNaN(this.min)) {
            this.min = r.min();
        }
        if (!Double.isNaN(r.min())) {
            this.min = Math.min(r.min(), this.min);
        }
        if (Double.isNaN(this.max)) {
            this.max = r.max();
        }
        if (!Double.isNaN(r.max())) {
            this.max = Math.max(r.max(), this.max);
        }
    }

    static {
        labelColumns.put(LabelType.RUN_ID, 0);
        labelColumns.put(LabelType.CUSTOM_KEY, 1);
        labelColumns.put(LabelType.TIMESTAMP, 2);
    }

    private static final class StringHolder {
        public String value;

        public StringHolder(String value) {
            this.value = value;
        }
    }
}

