/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.security.tokens;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.security.auth.DestroyFailedException;
import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.util.ByteBufferUtil;
import org.apache.hadoop.io.WritableUtils;

public class PasswordToken
implements AuthenticationToken {
    private byte[] password = null;

    public byte[] getPassword() {
        return Arrays.copyOf(this.password, this.password.length);
    }

    public PasswordToken() {
        this.password = new byte[0];
    }

    public PasswordToken(CharSequence password) {
        this.setPassword(CharBuffer.wrap(password));
    }

    public PasswordToken(byte[] password) {
        this.password = Arrays.copyOf(password, password.length);
    }

    public PasswordToken(ByteBuffer password) {
        this.password = ByteBufferUtil.toBytes(password);
    }

    public void readFields(DataInput arg0) throws IOException {
        this.password = WritableUtils.readCompressedByteArray((DataInput)arg0);
    }

    public void write(DataOutput arg0) throws IOException {
        WritableUtils.writeCompressedByteArray((DataOutput)arg0, (byte[])this.password);
    }

    @Override
    public void destroy() throws DestroyFailedException {
        Arrays.fill(this.password, (byte)0);
        this.password = null;
    }

    @Override
    public boolean isDestroyed() {
        return this.password == null;
    }

    public int hashCode() {
        return Arrays.hashCode(this.password);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PasswordToken)) {
            return false;
        }
        PasswordToken other = (PasswordToken)obj;
        return Arrays.equals(this.password, other.password);
    }

    @Override
    public PasswordToken clone() {
        try {
            PasswordToken clone = (PasswordToken)super.clone();
            clone.password = Arrays.copyOf(this.password, this.password.length);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    protected void setPassword(byte[] password) {
        this.password = Arrays.copyOf(password, password.length);
    }

    protected void setPassword(CharBuffer charBuffer) {
        ByteBuffer bb = Constants.UTF8.encode(charBuffer);
        this.password = new byte[bb.remaining()];
        bb.get(this.password);
        if (!bb.isReadOnly()) {
            bb.rewind();
            while (bb.remaining() > 0) {
                bb.put((byte)0);
            }
        }
    }

    @Override
    public void init(AuthenticationToken.Properties properties) {
        if (!properties.containsKey("password")) {
            throw new IllegalArgumentException("Missing 'password' property");
        }
        this.setPassword(CharBuffer.wrap(properties.get("password")));
    }

    @Override
    public Set<AuthenticationToken.TokenProperty> getProperties() {
        LinkedHashSet<AuthenticationToken.TokenProperty> internal = new LinkedHashSet<AuthenticationToken.TokenProperty>();
        internal.add(new AuthenticationToken.TokenProperty("password", "the password for the principal", true));
        return internal;
    }
}

