/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.iterators.system;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.accumulo.core.data.ArrayByteSequence;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Column;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.Filter;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;

public class ColumnQualifierFilter
extends Filter {
    private boolean scanColumns;
    private HashSet<ByteSequence> columnFamilies;
    private HashMap<ByteSequence, HashSet<ByteSequence>> columnsQualifiers;

    public ColumnQualifierFilter() {
    }

    public ColumnQualifierFilter(SortedKeyValueIterator<Key, Value> iterator, Set<Column> columns) {
        this.setSource(iterator);
        this.init(columns);
    }

    public ColumnQualifierFilter(SortedKeyValueIterator<Key, Value> iterator, HashSet<ByteSequence> columnFamilies, HashMap<ByteSequence, HashSet<ByteSequence>> columnsQualifiers, boolean scanColumns) {
        this.setSource(iterator);
        this.columnFamilies = columnFamilies;
        this.columnsQualifiers = columnsQualifiers;
        this.scanColumns = scanColumns;
    }

    @Override
    public boolean accept(Key key, Value v) {
        if (!this.scanColumns) {
            return true;
        }
        if (this.columnFamilies.contains(key.getColumnFamilyData())) {
            return true;
        }
        HashSet<ByteSequence> cfset = this.columnsQualifiers.get(key.getColumnQualifierData());
        return cfset != null && cfset.contains(key.getColumnFamilyData());
    }

    public void init(Set<Column> columns) {
        this.columnFamilies = new HashSet();
        this.columnsQualifiers = new HashMap();
        for (Column col : columns) {
            if (col.columnQualifier != null) {
                ArrayByteSequence cq = new ArrayByteSequence(col.columnQualifier);
                HashSet<ByteSequence> cfset = this.columnsQualifiers.get(cq);
                if (cfset == null) {
                    cfset = new HashSet();
                    this.columnsQualifiers.put(cq, cfset);
                }
                cfset.add(new ArrayByteSequence(col.columnFamily));
                continue;
            }
            this.columnFamilies.add(new ArrayByteSequence(col.columnFamily));
        }
        this.scanColumns = this.columnsQualifiers.size() > 0;
    }

    @Override
    public SortedKeyValueIterator<Key, Value> deepCopy(IteratorEnvironment env) {
        return new ColumnQualifierFilter(this.getSource().deepCopy(env), this.columnFamilies, this.columnsQualifiers, this.scanColumns);
    }
}

