/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.serializer.kryo;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.vertexium.VertexiumException;
import org.vertexium.VertexiumSerializer;
import org.vertexium.serializer.kryo.quickSerializers.BigDecimalQuickTypeSerializer;
import org.vertexium.serializer.kryo.quickSerializers.DateQuickTypeSerializer;
import org.vertexium.serializer.kryo.quickSerializers.DoubleQuickTypeSerializer;
import org.vertexium.serializer.kryo.quickSerializers.KryoQuickTypeSerializer;
import org.vertexium.serializer.kryo.quickSerializers.LongQuickTypeSerializer;
import org.vertexium.serializer.kryo.quickSerializers.QuickTypeSerializer;
import org.vertexium.serializer.kryo.quickSerializers.StringQuickTypeSerializer;

public class QuickKryoVertexiumSerializer
implements VertexiumSerializer {
    private static final byte[] EMPTY = new byte[0];
    private QuickTypeSerializer defaultQuickTypeSerializer = new KryoQuickTypeSerializer();
    private Map<Class, QuickTypeSerializer> quickTypeSerializersByClass = new HashMap<Class, QuickTypeSerializer>(){
        {
            this.put(String.class, new StringQuickTypeSerializer());
            this.put(Long.class, new LongQuickTypeSerializer());
            this.put(Date.class, new DateQuickTypeSerializer());
            this.put(Double.class, new DoubleQuickTypeSerializer());
            this.put(BigDecimal.class, new BigDecimalQuickTypeSerializer());
        }
    };
    private Map<Byte, QuickTypeSerializer> quickTypeSerializersByMarker = new HashMap<Byte, QuickTypeSerializer>(){
        {
            this.put((byte)0, new KryoQuickTypeSerializer());
            this.put((byte)1, new StringQuickTypeSerializer());
            this.put((byte)2, new LongQuickTypeSerializer());
            this.put((byte)3, new DateQuickTypeSerializer());
            this.put((byte)4, new DoubleQuickTypeSerializer());
            this.put((byte)5, new BigDecimalQuickTypeSerializer());
        }
    };

    public byte[] objectToBytes(Object object) {
        if (object == null) {
            return EMPTY;
        }
        QuickTypeSerializer quickTypeSerializer = this.quickTypeSerializersByClass.get(object.getClass());
        if (quickTypeSerializer != null) {
            return quickTypeSerializer.objectToBytes(object);
        }
        return this.defaultQuickTypeSerializer.objectToBytes(object);
    }

    public <T> T bytesToObject(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        QuickTypeSerializer quickTypeSerializer = this.quickTypeSerializersByMarker.get(bytes[0]);
        if (quickTypeSerializer != null) {
            return quickTypeSerializer.valueToObject(bytes);
        }
        throw new VertexiumException("Invalid marker: " + Integer.toHexString(bytes[0]));
    }
}

