/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.connectionpool;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.netflix.astyanax.connectionpool.TokenRange;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Host
implements Comparable<Host> {
    public static final Host NO_HOST = new Host();
    public static final String UKNOWN_RACK = "";
    private final String host;
    private final String ipAddress;
    private final int port;
    private final String name;
    private final String url;
    private String rack = "";
    private String id;
    private Set<String> alternateIpAddress = Sets.newHashSet();
    private List<TokenRange> ranges = Lists.newArrayList();
    public static Pattern IP_ADDR_PATTERN = Pattern.compile("^(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])$");

    private Host() {
        this.host = "None";
        this.ipAddress = "0.0.0.0";
        this.port = 0;
        this.name = String.format("%s(%s):%d", this.host, this.ipAddress, this.port);
        this.url = String.format("%s:%d", this.host, this.port);
    }

    public Host(String hostAndPort, int defaultPort) {
        String workIpAddress;
        String workHost;
        String tempHost = Host.parseHostFromHostAndPort(hostAndPort);
        this.port = Host.parsePortFromHostAndPort(hostAndPort, defaultPort);
        Matcher match = IP_ADDR_PATTERN.matcher(tempHost);
        if (match.matches()) {
            workHost = tempHost;
            workIpAddress = tempHost;
        } else {
            try {
                InetAddress address = InetAddress.getByName(tempHost);
                workHost = address.getHostName();
                workIpAddress = address.getHostAddress();
            }
            catch (UnknownHostException e) {
                workHost = tempHost;
                workIpAddress = tempHost;
            }
        }
        this.host = workHost;
        this.ipAddress = workIpAddress;
        this.name = String.format("%s(%s):%d", tempHost, this.ipAddress, this.port);
        this.url = String.format("%s:%d", this.host, this.port);
    }

    public static String parseHostFromHostAndPort(String hostAndPort) {
        return hostAndPort.lastIndexOf(58) > 0 ? hostAndPort.substring(0, hostAndPort.lastIndexOf(58)) : hostAndPort;
    }

    public static int parsePortFromHostAndPort(String urlPort, int defaultPort) {
        return urlPort.lastIndexOf(58) > 0 ? Integer.valueOf(urlPort.substring(urlPort.lastIndexOf(58) + 1, urlPort.length())) : defaultPort;
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Host)) {
            return false;
        }
        Host other = (Host)obj;
        return (other.host.equals(this.host) || other.ipAddress.equals(this.ipAddress)) && other.port == this.port;
    }

    public int hashCode() {
        return this.host.hashCode() + this.port;
    }

    public String getName() {
        return this.name;
    }

    public String getUrl() {
        return this.url;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public String getHostName() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public Set<String> getAlternateIpAddresses() {
        return this.alternateIpAddress;
    }

    public Host addAlternateIpAddress(String ipAddress) {
        this.alternateIpAddress.add(ipAddress);
        return this;
    }

    public String getId() {
        return this.id;
    }

    public Host setId(String id) {
        this.id = id;
        return this;
    }

    public Host setRack(String rack) {
        this.rack = rack;
        return this;
    }

    public String getRack() {
        return this.rack;
    }

    public synchronized Host setTokenRanges(List<TokenRange> ranges) {
        this.ranges = ranges;
        return this;
    }

    public synchronized List<TokenRange> getTokenRanges() {
        return this.ranges;
    }

    @Override
    public int compareTo(Host other) {
        int comp = this.host.compareTo(other.host);
        if (comp != 0) {
            comp = this.ipAddress.compareTo(other.ipAddress);
        }
        if (comp == 0) {
            comp = this.port - other.port;
        }
        return comp;
    }
}

