/*
 * Decompiled with CFR 0.152.
 */
package org.semarglproject.sink;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import org.semarglproject.rdf.ParseException;
import org.semarglproject.sink.CharSink;

public final class CharOutputSink
implements CharSink {
    private File file;
    private Writer writer;
    private OutputStream outputStream;
    private boolean closeOnEndStream;
    private final Charset charset;

    public CharOutputSink() {
        this(Charset.defaultCharset());
    }

    public CharOutputSink(Charset charset) {
        this.charset = charset;
    }

    public CharOutputSink(String charsetName) {
        this.charset = Charset.forName(charsetName);
    }

    public void connect(File file) {
        this.file = file;
        this.writer = null;
        this.outputStream = null;
        this.closeOnEndStream = true;
    }

    public void connect(Writer writer) {
        this.file = null;
        this.writer = writer;
        this.outputStream = null;
        this.closeOnEndStream = false;
    }

    public void connect(OutputStream outputStream) {
        this.file = null;
        this.writer = null;
        this.outputStream = outputStream;
        this.closeOnEndStream = false;
    }

    @Override
    public void process(String line) throws ParseException {
        try {
            this.writer.write(line);
        }
        catch (IOException e) {
            throw new ParseException(e);
        }
    }

    @Override
    public void setBaseUri(String baseUri) {
    }

    @Override
    public void startStream() throws ParseException {
        if (this.writer == null) {
            if (this.file != null) {
                try {
                    this.writer = new OutputStreamWriter((OutputStream)new FileOutputStream(this.file), this.charset);
                }
                catch (FileNotFoundException e) {
                    throw new ParseException(e);
                }
            } else if (this.outputStream != null) {
                this.writer = new OutputStreamWriter(this.outputStream, this.charset);
            }
        }
    }

    @Override
    public void endStream() throws ParseException {
        try {
            this.writer.flush();
        }
        catch (IOException e) {
            throw new ParseException(e);
        }
        if (this.closeOnEndStream) {
            if (this.writer != null) {
                CharOutputSink.closeQuietly(this.writer);
                this.writer = null;
            } else if (this.outputStream != null) {
                CharOutputSink.closeQuietly(this.outputStream);
                this.outputStream = null;
            }
        }
    }

    @Override
    public boolean setProperty(String key, Object value) {
        return false;
    }

    private static void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

