/*
 * Decompiled with CFR 0.152.
 */
package org.semarglproject.source;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import org.semarglproject.rdf.ParseException;
import org.semarglproject.sink.SaxSink;
import org.semarglproject.source.AbstractSource;
import org.semarglproject.source.BaseStreamProcessor;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

final class SaxSource
extends AbstractSource<SaxSink> {
    private XMLReader xmlReader = null;

    SaxSource(SaxSink sink) {
        super(sink);
    }

    @Override
    public void process(Reader reader, String mimeType, String baseUri) throws ParseException {
        try {
            this.initXmlReader();
        }
        catch (SAXException e) {
            throw new ParseException("Can not instantinate XMLReader", e);
        }
        try {
            ((SaxSink)this.sink).setBaseUri(baseUri);
            this.xmlReader.parse(new InputSource(reader));
        }
        catch (SAXException e) {
            ParseException wrappedException = ((SaxSink)this.sink).processException(e);
            try {
                ((SaxSink)this.sink).endDocument();
            }
            catch (SAXException e2) {
                // empty catch block
            }
            throw wrappedException;
        }
        catch (IOException e) {
            throw new ParseException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(InputStream inputStream, String mimeType, String baseUri) throws ParseException {
        InputStreamReader reader = new InputStreamReader(inputStream, Charset.forName("UTF-8"));
        try {
            this.process(reader, mimeType, baseUri);
        }
        finally {
            BaseStreamProcessor.closeQuietly(reader);
        }
    }

    private void initXmlReader() throws SAXException {
        if (this.xmlReader == null) {
            this.xmlReader = XMLReaderFactory.createXMLReader();
            this.xmlReader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        }
        this.xmlReader.setContentHandler((ContentHandler)((Object)this.sink));
        this.xmlReader.setProperty("http://xml.org/sax/properties/lexical-handler", this.sink);
    }

    public void setXmlReader(XMLReader xmlReader) {
        this.xmlReader = xmlReader;
    }
}

