/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.fate;

import java.io.Serializable;
import java.util.EnumSet;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.accumulo.fate.ReadOnlyTStore;
import org.apache.accumulo.fate.Repo;
import org.apache.accumulo.fate.StackOverflowException;
import org.apache.accumulo.fate.TStore;
import org.apache.accumulo.fate.util.Daemon;
import org.apache.accumulo.fate.util.LoggingRunnable;
import org.apache.log4j.Logger;

public class Fate<T> {
    private static final String DEBUG_PROP = "debug";
    private static final String AUTO_CLEAN_PROP = "autoClean";
    private static final String EXCEPTION_PROP = "exception";
    private static final String RETURN_PROP = "return";
    private static final Logger log = Logger.getLogger(Fate.class);
    private TStore<T> store;
    private T environment;
    private static final EnumSet<ReadOnlyTStore.TStatus> FINISHED_STATES = EnumSet.of(ReadOnlyTStore.TStatus.FAILED, ReadOnlyTStore.TStatus.SUCCESSFUL, ReadOnlyTStore.TStatus.UNKNOWN);
    private AtomicBoolean keepRunning = new AtomicBoolean(true);

    public Fate(T environment, TStore<T> store, int numThreads) {
        this.store = store;
        this.environment = environment;
        for (int i = 0; i < numThreads; ++i) {
            Daemon thread = new Daemon(new LoggingRunnable(log, new TransactionRunner()), "Repo runner " + i);
            thread.start();
        }
    }

    public long startTransaction() {
        long dir = this.store.create();
        return dir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void seedTransaction(long tid, Repo<T> repo, boolean autoCleanUp) {
        block7: {
            this.store.reserve(tid);
            try {
                if (this.store.getStatus(tid) != ReadOnlyTStore.TStatus.NEW) break block7;
                if (this.store.top(tid) == null) {
                    try {
                        this.store.push(tid, repo);
                    }
                    catch (StackOverflowException e) {
                        throw new RuntimeException(e);
                    }
                }
                if (autoCleanUp) {
                    this.store.setProperty(tid, AUTO_CLEAN_PROP, Boolean.valueOf(autoCleanUp));
                }
                this.store.setProperty(tid, DEBUG_PROP, (Serializable)((Object)repo.getDescription()));
                this.store.setStatus(tid, ReadOnlyTStore.TStatus.IN_PROGRESS);
            }
            finally {
                this.store.unreserve(tid, 0L);
            }
        }
    }

    public ReadOnlyTStore.TStatus waitForCompletion(long tid) {
        return this.store.waitForStatusChange(tid, FINISHED_STATES);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void delete(long tid) {
        this.store.reserve(tid);
        try {
            switch (this.store.getStatus(tid)) {
                case NEW: 
                case FAILED: 
                case SUCCESSFUL: {
                    this.store.delete(tid);
                    return;
                }
                case FAILED_IN_PROGRESS: 
                case IN_PROGRESS: {
                    throw new IllegalStateException("Can not delete in progress transaction " + String.format("%016x", tid));
                }
            }
            return;
        }
        finally {
            this.store.unreserve(tid, 0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getReturn(long tid) {
        this.store.reserve(tid);
        try {
            if (this.store.getStatus(tid) != ReadOnlyTStore.TStatus.SUCCESSFUL) {
                throw new IllegalStateException("Tried to get exception when transaction " + String.format("%016x", tid) + " not in successful state");
            }
            String string = (String)((Object)this.store.getProperty(tid, RETURN_PROP));
            return string;
        }
        finally {
            this.store.unreserve(tid, 0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Exception getException(long tid) {
        this.store.reserve(tid);
        try {
            if (this.store.getStatus(tid) != ReadOnlyTStore.TStatus.FAILED) {
                throw new IllegalStateException("Tried to get exception when transaction " + String.format("%016x", tid) + " not in failed state");
            }
            Exception exception = (Exception)this.store.getProperty(tid, EXCEPTION_PROP);
            return exception;
        }
        finally {
            this.store.unreserve(tid, 0L);
        }
    }

    public void shutdown() {
        this.keepRunning.set(false);
    }

    static /* synthetic */ AtomicBoolean access$000(Fate x0) {
        return x0.keepRunning;
    }

    private class TransactionRunner
    implements Runnable {
        private TransactionRunner() {
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 5[CATCHBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private void transitionToFailed(long tid, Repo<T> op, Exception e) {
            String tidStr = String.format("%016x", tid);
            log.warn((Object)("Failed to execute Repo, tid=" + tidStr), (Throwable)e);
            Fate.this.store.setProperty(tid, Fate.EXCEPTION_PROP, e);
            Fate.this.store.setStatus(tid, ReadOnlyTStore.TStatus.FAILED_IN_PROGRESS);
            log.info((Object)("Updated status for Repo with tid=" + tidStr + " to FAILED_IN_PROGRESS"));
        }

        private void processFailed(long tid, Repo<T> op) {
            while (op != null) {
                this.undo(tid, op);
                Fate.this.store.pop(tid);
                op = Fate.this.store.top(tid);
            }
            Fate.this.store.setStatus(tid, ReadOnlyTStore.TStatus.FAILED);
            this.doCleanUp(tid);
        }

        private void doCleanUp(long tid) {
            Boolean autoClean = (Boolean)Fate.this.store.getProperty(tid, Fate.AUTO_CLEAN_PROP);
            if (autoClean != null && autoClean.booleanValue()) {
                Fate.this.store.delete(tid);
            } else {
                while (Fate.this.store.top(tid) != null) {
                    Fate.this.store.pop(tid);
                }
            }
        }

        private void undo(long tid, Repo<T> op) {
            try {
                op.undo(tid, Fate.this.environment);
            }
            catch (Exception e) {
                log.warn((Object)("Failed to undo Repo, tid=" + String.format("%016x", tid)), (Throwable)e);
            }
        }
    }
}

